/*
	This is the JavaScript file for the How to Create CAPTCHA Protection using PHP and AJAX Tutorial

	You may use this code in your own projects as long as this 
	copyright is left in place.  All code is provided AS-IS.
	This code is distributed in the hope that it will be useful,
 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	
	For the rest of the code visit http://www.WebCheatSheet.com
	
	Copyright 2006 WebCheatSheet.com	

*/
//Gets the browser specific XmlHttpRequest Object 
var siteurl="http://www.cvjob.dk/";
//var siteurl="http://phuocdb.mwc.com.vn/cvjob/";
function getXmlHttpRequestObject() {
 if (window.XMLHttpRequest) {
    return new XMLHttpRequest(); //Mozilla, Safari ...
 } else if (window.ActiveXObject) {
    return new ActiveXObject("Microsoft.XMLHTTP"); //IE
 } else {
    //Display our error message
    alert("Your browser doesn't support the XmlHttpRequest object.");
 }
}

//Our XmlHttpRequest object
var receiveReq = getXmlHttpRequestObject();

//Initiate the AJAX request
function makeRequest(url, param) {
//If our readystate is either not started or finished, initiate a new request
 if (receiveReq.readyState == 4 || receiveReq.readyState == 0) {
   //Set up the connection to captcha_test.html. True sets the request to asyncronous(default) 
   receiveReq.open("POST", url, true);
   //Set the function that will be called when the XmlHttpRequest objects state changes
   receiveReq.onreadystatechange = updatePage; 

   receiveReq.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
   receiveReq.setRequestHeader("Content-length", param.length);
   receiveReq.setRequestHeader("Connection", "close");

   //Make the request
   receiveReq.send(param);
 }   
}

//Called every time our XmlHttpRequest objects state changes
function updatePage() {
 //Check if our response is ready
 if (receiveReq.readyState == 4) {
   //Set the content of the DIV element with the response text
   document.getElementById('result').innerHTML = receiveReq.responseText;
   //Get a reference to CAPTCHA image
   if (receiveReq.responseText==0)
   {
	   //img = document.getElementById('imgCaptcha'); 
	   //Change the image
	   //img.src = siteurl+'assets/captcha/create_image.php?' + Math.random();
   }
   else
   {
		document.getElementById("captchainvalid").style.display="none";  
	}
 }
}

//Called every time when form is perfomed
function getParam(theForm) {
 //Set the URL
 var url = siteurl+'result_captcha/';
 //Set up the parameters of our AJAX call
 var postStr = theForm.captcha.name + "=" + encodeURIComponent( theForm.captcha.value );
 //Call the function that initiate the AJAX request
 makeRequest(url, postStr);
}