/*!
 * Start Bootstrap - SB Admin 2 v3.3.7+1 (http://startbootstrap.com/template-overviews/sb-admin-2)
 * Copyright 2013-2016 Start Bootstrap
 * Licensed under MIT (https://github.com/BlackrockDigital/startbootstrap/blob/gh-pages/LICENSE)
 */
$(function() {
    $('#side-menu').metisMenu();

    $('[data-toggle="tooltip"]').tooltip();

    $(".chosen-select").chosen();
    
    $('.data-table').DataTable();
    
    $(".product-list").css("width",$(".drop-down-product").outerWidth());
    
    $('.reservation').daterangepicker({locale: {format: 'DD.MM.YYYY' }});
    
    $('[data-toggle="popover"]').popover({html:true});
    
    $('body').on('click', function (e) {
        //did not click a popover toggle or popover
        if ($(e.target).data('toggle') !== 'popover'
            && $(e.target).parents('.popover.in').length === 0) { 
            $('[data-toggle="popover"]').popover('hide');
        }
    });
    
});

$('#search_by_year').change(function() {
    this.form.submit();
});

$(document).on("focusin",".datepicker", function () {
    $(this).datepicker({
        autoclose: true,
        todayHighlight: true,
        format: 'dd-mm-yyyy'
    });
});

//Loads the correct sidebar on window load,
//collapses the sidebar on window resize.
// Sets the min-height of #page-wrapper to window size
$(function() {
    $(window).bind("load resize", function() {
        var topOffset = 50;
        var width = (this.window.innerWidth > 0) ? this.window.innerWidth : this.screen.width;
        if (width < 768) {
            $('div.navbar-collapse').addClass('collapse');
            topOffset = 100; // 2-row-menu
        } else {
            $('div.navbar-collapse').removeClass('collapse');
        }

        var height = ((this.window.innerHeight > 0) ? this.window.innerHeight : this.screen.height) - 1;
        height = height - topOffset;
        if (height < 1) height = 1;
        if (height > topOffset) {
            $("#page-wrapper").css("min-height", (height+120) + "px");
        }
    });

    var url = window.location;
    // var element = $('ul.nav a').filter(function() {
    //     return this.href == url;
    // }).addClass('active').parent().parent().addClass('in').parent();
    var element = $('ul.nav a').filter(function() {
        return this.href == url;
    }).addClass('active').parent();

    while (true) {
        if (element.is('li')) {
            element = element.parent().addClass('in').parent();
        } else {
            break;
        }
    }
});

function getFormattedDate(date) {
    var year = date.getFullYear();
    var month = (1 + date.getMonth()).toString();
    month = month.length > 1 ? month : '0' + month;
    var day = date.getDate().toString();
    day = day.length > 1 ? day : '0' + day;
    return  day+ '.' + month + '.' + year;
}


Number.prototype.format = function(n, x, s, c) {
    var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\D' : '$') + ')',
        num = this.toFixed(Math.max(0, ~~n));

    return (c ? num.replace('.', c) : num).replace(new RegExp(re, 'g'), '$&' + (s || ','));
};


$('.BookingMemberSearch').on('change', function() {
	var base_url = $("#base_url").val();
	var lang = $("#lang").val();
  window.location.href = base_url + lang +"/booking?id="+this.value;
});

$('.DirectBookingMemberSearch').on('change', function() {
	var base_url = $("#base_url").val();
	var lang = $("#lang").val();
  window.location.href = base_url + lang +"/direct-payment?e_id="+this.value;
});

$('.PaymentMemberSearch').on('change', function() {
	var base_url = $("#base_url").val();
	var lang = $("#lang").val();
  window.location.href = base_url + lang +"/payment?e_id="+this.value;
});

$(document).on('click', '.deleteRow' ,function(){
	var base_url = $("#base_url").val();
	var lang = $("#lang").val();
	var table = $(this).data("table");
	var field = $(this).data("field");
	var id = $(this).data("id");
	$.confirm({
        title: 'Confirm!',
        content: 'Are you sure to delete this record permanently?',
        buttons: {

            confirm: {
                text: 'Confirm',
                btnClass: 'btn btn-primary',
                action: function () {
                    jQuery.ajax({
                        url: base_url+lang+'/delete/'+table+'/'+field+'/'+id,
                        type: "POST",
                        success:function(data){
                        	var json = JSON.parse(data);
                            if(json.status=='success'){
                            	$(".remove_"+id).hide();
                            }
                            $('.top-right').notify({
                                message: {text: json.message},
                                type: json.status
                            }).show();
                        }
                    });
                }
            },
            cancel: function () {
               // return false;
            }
        }
    });	
});

$(document).on('click', '.GenerateBackup' ,function(){
	var base_url = $("#base_url").val();
	var lang = $("#lang").val();
	$.confirm({
        title: 'Confirm!',
        content: 'Are you sure to backup database?',
        buttons: {

            confirm: {
                text: 'Confirm',
                btnClass: 'btn btn-primary',
                action: function () {
                    jQuery.ajax({
                        url: base_url+lang+'/backup?g=generate',
                        type: "POST",
                        success:function(data){
                        	location.reload();
                        }
                    });
                }
            },
            cancel: function () {
               // return false;
            }
        }
    });	
});
$(document).ready(function() {
	
		var base_url = $("#base_url").val();
		var lang = $("#lang").val();
	   var calendar = $('#calendar').fullCalendar({
	    editable:true,
	    header:{
	     left:'prev,next today',
	     center:'title',
	     right:'month,agendaWeek,agendaDay'
	    },
	    events: base_url+lang+"/calendar?action=load_event",
	    timeFormat: ' ',
	    selectable:true,
	    selectHelper:true,
	    select: function(start, end, allDay)
	    {
	     var title = prompt("Enter Event Title");
	     if(title)
	     {
	      var start = $.fullCalendar.formatDate(start, "Y-MM-DD HH:mm:ss");
	      var end = $.fullCalendar.formatDate(end, "Y-MM-DD HH:mm:ss");
	      $.ajax({
	       url:	base_url+lang+"/calendar?action=insert",
	       type:"POST",
	       data:{title:title, start:start, end:end},
	       success:function()
	       {
	        calendar.fullCalendar('refetchEvents');
	        alert("Added Successfully");
	       }
	      })
	     }
	    },
	    editable:true,
	    eventResize:function(event)
	    {
	     var start = $.fullCalendar.formatDate(event.start, "Y-MM-DD HH:mm:ss");
	     var end = $.fullCalendar.formatDate(event.end, "Y-MM-DD HH:mm:ss");
	     var title = event.title;
	     var id = event.id;
	     $.ajax({
	      url: base_url+lang+"/calendar?action=update",
	      type:"POST",
	      data:{title:title, start:start, end:end, id:id},
	      success:function(){
	       calendar.fullCalendar('refetchEvents');
	       alert('Event Update');
	      }
	     })
	    },

	    eventDrop:function(event)
	    {
	     var start = $.fullCalendar.formatDate(event.start, "Y-MM-DD HH:mm:ss");
	     var end = $.fullCalendar.formatDate(event.end, "Y-MM-DD HH:mm:ss");
	     var title = event.title;
	     var id = event.id;
	     $.ajax({
	      url:base_url+lang+"/calendar?action=update",
	      type:"POST",
	      data:{title:title, start:start, end:end, id:id},
	      success:function()
	      {
	       calendar.fullCalendar('refetchEvents');
	       alert("Event Updated");
	      }
	     });
	    },

	    eventClick:function(event)
	    {
	     if(confirm("Are you sure you want to remove it?"))
	     {
	      var id = event.id;
	      $.ajax({
	       url:base_url+lang+"/calendar?action=delete",
	       type:"POST",
	       data:{id:id},
	       success:function()
	       {
	        calendar.fullCalendar('refetchEvents');
	        alert("Event Removed");
	       }
	      })
	     }
	    }

	   });
	   
	   
	   var calendar_dashboard = $('#calendar_dashboard').fullCalendar({
		    editable:true,
		    header:{
		     left:'prev,next today',
		     center:'title',
		     right:'month,agendaWeek,agendaDay'
		    },
		    events: base_url+lang+"/calendar?action=load_event",
		    timeFormat: ' ',
		    selectable:true,
		    selectHelper:true
		    });
	    });

$(document).ready(function(){
    $('#file_input').on('change', function(){ //on file input change
        if (window.File && window.FileReader && window.FileList && window.Blob) //check File API supported browser
        {
            $('#thumb-output').html(''); //clear html of output element
            var data = $(this)[0].files; //this file data
            
            $.each(data, function(index, file){ //loop though each file
                if(/(\.|\/)(gif|jpe?g|png)$/i.test(file.type)){ //check supported file type
                    var fRead = new FileReader(); //new filereader
                    fRead.onload = (function(file){ //trigger function on successful read
                    return function(e) {
                        var img = $('<img/>').addClass('thumb-img').attr('src', e.target.result); //create image element 
                        $('#thumb-output').append(img); //append image to output element
                        $('.icon-upload').css("display","none");
                    };
                    })(file);
                    fRead.readAsDataURL(file); //URL representing the file's data.
                }
            });
            
        }else{
            alert("Your browser doesn't support File API!"); //if File API is absent
        }
    });
});

$(document).ready(function(){
	
	$('#start_date').change(function() {
		  var last_day = $('#no_of_days').val();
		  var date2 = $('#start_date').datepicker('getDate'); 
		  date2.setDate(date2.getDate()+parseInt(last_day-1)); 
		  $('#expire_date').datepicker('setDate', date2);
	});
    
    
	
	$('.auto-submit').change(function() {
		this.form.submit();
    });
	
    $( document ).on( 'focus', ':input', function(){
        $( this ).attr( 'autocomplete', 'off' );
    });
    
    $("#installment").keyup(function(){
    	var key_value = this.value;
    	var base_url = $("#base_url").val();
    	var lang = $("#lang").val();
        var html = '';
        $.ajax({
            type: 'POST',
            url: base_url+lang+'/ajax',
            data: {'page_type':'booking_installment', 'key_value': key_value},
            success: function (data) {
            	$(".installment-list").html(data);
            }
        });
    });
    
    $(".password-advance").blur(function(){
    	var key_value = this.value;
    	
    	var html = '';
    	if(key_value!=''){
	    	if(/^(?=.*?[A-Z])/.test(key_value)){    		
	        }else{
	        	html += '<span class="text-red">At least one upper case</span><br>';
	        }
	    	if(/^(?=.*?[a-z])/.test(key_value)){    		
	        }else{
	        	html += '<span class="text-red">At least one lower case</span><br>';
	        }
	    	if(/^(?=.*?[0-9])/.test(key_value)){    		
	        }else{
	        	html += '<span class="text-red">At least one Digit</span><br>';
	        }
	    	if(/^(?=.*?[#?!@$%^&*-])/.test(key_value)){    		
	        }else{
	        	html += '<span class="text-red">At least one special character,</span><br>';
	        }
	    	if(/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}/.test(key_value)){    		
	        }else{
	        	html += '<span class="text-red">Minimum Six in length</span><br>';
	        }
    	}
	    	$("#password-error").html(html);
    	
    	if(html==''){
    		$(".password-btn").removeAttr("disabled");
    	}else{
    		$(".password-btn").prop("disabled", true);
    	}
    });
    
    $( ".edit-payment" ).click(function() {
    	var id = $(this).data("id");
    	var base_url = $("#base_url").val();
    	var lang = $("#lang").val();
    	$.ajax({
            type: 'POST',
            url: base_url+lang+'/ajax',
            data: {'page_type':'payment_info', 'payment_id': id},
            success: function (data) {
            	var json = JSON.parse(data);
            	if(json){
            		$("#payment_number").html(json.payment_number);
            		$("#payment_amount").val(json.payment_amount);
            		$("#payment_amount_label").html(json.payment_amount);
            		$("#payment_id").val(json.payment_id);
            		
            		$(".datepicker-ajax").datepicker({
                	    format: 'dd-mm-yyyy',
                	    todayHighlight: true,
                	    autoclose: true
                	 }).datepicker("update", json.payment_date);
            	}
            }
        });
	});
	
	$( "#update-payment" ).click(function() {
		var payment_amount = $("#payment_amount").val();
		var payment_date = $("#payment_date").val();
		var payment_id = $("#payment_id").val();
    	var base_url = $("#base_url").val();
    	var lang = $("#lang").val();
    	$.ajax({
            type: 'POST',
            url: base_url+lang+'/ajax',
            data: {'page_type':'payment_info_update', 'payment_id': payment_id, 'payment_amount': payment_amount, 'payment_date': payment_date},
            success: function (data) {
            	var json = JSON.parse(data);
            	$('.top-right').notify({
                    message: {text: json.message},
                    type: json.status
                }).show();
            	setTimeout(function() {
            	    location.reload();
            	}, 2000);
            }
        });
	});
    
	$(".vat-status").click(function() {
        var vat_val = $(this).val();
        if(vat_val==1) {
        	$(".vat-detail").removeClass("display-hide");
        	$(".vat-detail").addClass("display-show");
        }else{
        	$(".vat-detail").removeClass("display-show");
        	$(".vat-detail").addClass("display-hide");
        }
	});
	
    $(".full-payment").click(function() {
        var pay_val = $(this).val();
        
        if(pay_val==1) {
        	$(".fullpayment_div").show(300);
        	$(".installment_div").hide(200);
        	$(".installment-list").html('');
        	var base_url = $("#base_url").val();
        	var lang = $("#lang").val();
            var html = '';
            $.ajax({
                type: 'POST',
                url: base_url+lang+'/ajax',
                data: {'page_type':'full_payment'},
                success: function (data) {
                	$(".fullpayment_div").html(data);
                }
            });
            
        } else {
        	$(".installment_div").show(300);
            $(".fullpayment_div").hide(300);
            $(".fullpayment_div").html('');
        }
    });
    
    
    $(document).on('click', '.add-more-proof' ,function(){
    	$(this).addClass("remove-proof");
    	$(this).removeClass("add-more-proof");
    	$(this).html('<i class="fa fa-minus"></i>');
    	var base_url = $("#base_url").val();
    	var lang = $("#lang").val();
    	var id = $(this).data('id');
    	
    	var html = '';
        $.ajax({
            type: 'POST',
            url: base_url+lang+'/ajax',
            data: {'page_type':'proof','id':id},
            success: function (data) {
            	$(".next-proof").before(data);
            }
        });
    	
    });
    
    $(document).on('click', '.remove-proof' ,function(){
    	var id = $(this).data('id');
    	$(".remove_"+id).remove();
    });
    
    /*$("#full_yes").click(function() {
        if($(this).is(":checked")) {
        	$(".fullpayment_div").show(300);
        	$(".installment_div").hide(200);
        	$(".installment-list").html('');
        	var base_url = $("#base_url").val();
        	var lang = $("#lang").val();
            var html = '';
            $.ajax({
                type: 'POST',
                url: base_url+lang+'/ajax',
                data: {'page_type':'full_payment'},
                success: function (data) {
                	$(".fullpayment_div").html(data);
                }
            });
            
        } else {
        	$(".installment_div").show(300);
            $(".fullpayment_div").hide(300);
            $(".fullpayment_div").html('');
        }
    });*/
    
    $(document).on('keyup','.valiidate_total',function( e ) {  
    	var total = $(".valiidate_total");
    	var pkg_amount = $("#package_amount").val();
    	var tot = 0;
    	for(var i = 0; i < total.length; i++){
    	    tot += Number($(total[i]).val());
    	}
    	if(tot>pkg_amount){
    		$.alert({
    		    title: 'Alert!',
    		    content: 'Installment Amount Exceeds The Fees Amount'
    		});
    		$('.booking-btn').attr("disabled", true);
    	}else{
    		$('.booking-btn').attr("disabled", false);
    	}
    });
});


function GetPackageInfo(package_id) {
	var base_url = $("#base_url").val();
	var lang = $("#lang").val();
    var html = '';
    $.ajax({
        type: 'POST',
        url: base_url+lang+'/ajax',
        data: {'page_type':'package', 'package_id': package_id},
        success: function (data) {
        	var json = JSON.parse(data);
        	//console.log(json);
            if(json) {
            	if(json.vat_enable=='yes'){
            		$('.vat-display').css('display','block');
            	}else{
            		$('.vat-display').css('display','none');
            	}
            	$('#no_of_days').val(json.nod);
            	$('#package_amount').val(json.amount);
            	if(json.package_type==1){
            		$('#expire_date').val(json.expire_date);
            		$('.hide-class').removeClass('hide');
            	}else{
            		$('.hide-class').addClass('hide');
            	}
                
                $('.no_of_days_label').html(json.nod);
                $('.package_amount_label').html(json.amount_d);
                
                $('#actual_amount').val(json.actual_amount);
                $('#vat_amount').val(json.vat_amount);
                $('.actual_amount_label').html(json.actual_amount_d);
                $('.vat_amount_label').html(json.vat_amount_d);
                
                $('#vat_percentage').val(json.vat_percentage);
                $('.display-vat-percentage').html('VAT('+json.vat_percentage+' %) : ');
                
                $('.fullpayment_amount').val(json.amount);
            }else{
            	$('#no_of_days').val('');
                $('#package_amount').val('');
                $('#expire_date').val('');
                
                $('.no_of_days_label').html();
                $('.package_amount_label').html();
                $('.fullpayment_amount').val('');
                
                $('#actual_amount').val('');
                $('.actual_amount_label').html('');
                
                $('#vat_amount').val('');
                $('.vat_amount_label').html('');
                
                $('#vat_percentage').val('');
                $('.display-vat-percentage').html('');
            }
        }
    });
}

function GetPackageCountMember(no_of_customers) {
	var base_url = $("#base_url").val();
	var lang = $("#lang").val();
	var package_id = $("#package_id").val();
    var html = '';
    $.ajax({
        type: 'POST',
        url: base_url+lang+'/ajax',
        data: {'page_type':'package_member', 'package_id': package_id, 'no_of_customers': no_of_customers},
        success: function (data) {
        	//console.log(data);
        	var json = JSON.parse(data);
        	
            if(json) {
            	if(json.vat_enable=='yes'){
            		$('.vat-display').css('display','block');
            	}else{
            		$('.vat-display').css('display','none');
            	}
            	
            	$('#no_of_days').val(json.nod);
            	$('#package_amount').val(json.amount);
                $('#expire_date').val(json.expire_date);
                
                $('.no_of_days_label').html(json.nod);
                $('.package_amount_label').html(json.amount_d);
                
                $('#actual_amount').val(json.actual_amount);
                $('#vat_amount').val(json.vat_amount);
                $('.actual_amount_label').html(json.actual_amount_d);
                $('.vat_amount_label').html(json.vat_amount_d);
                
                $('#vat_percentage').val(json.vat_percentage);
                $('.display-vat-percentage').html('VAT('+json.vat_percentage+' %) : ');
                
                $('.fullpayment_amount').val(json.amount);
            }else{
            	$('#no_of_days').val('');
                $('#package_amount').val('');
                $('#expire_date').val('');
                
                $('.no_of_days_label').html();
                $('.package_amount_label').html();
                $('.fullpayment_amount').val('');
                
                $('#actual_amount').val('');
                $('.actual_amount_label').html('');
                
                $('#vat_amount').val('');
                $('.vat_amount_label').html('');
                
                $('#vat_percentage').val('');
                $('.display-vat-percentage').html('');
            }
        }
    });
}



$(document).ready(function(){
	$('#export_report').on('click',function(){
		var base_url = $("#base_url").val();
		var lang = $("#lang").val();
		var filter_name = $("#filter_name").val();
		var filter_date = $("#filter_date").val();
		var filter_package = $("#filter_package").val();
		var filter_pay_type = $("#filter_pay_type").val();
		 var win = window.open(base_url+lang+'/print-report?filter_name='+filter_name+'&filter_date='+filter_date+'&filter_package='+filter_package+'&filter_pay_type='+filter_pay_type+'&filter_submit=', '_blank');
		 if (win) {
		     win.focus();
		 } else {
		     alert('Please allow popups for this website');
		 }
	});
	
	$('#export_expire_package').on('click',function(){
		var base_url = $("#base_url").val();
		var lang = $("#lang").val();
		var filter_member = $("#filter_member").val();
		var filter_package = $("#filter_package").val();
		var filter_status = $("#filter_status").val();
		 var win = window.open(base_url+lang+'/print-expire-package?filter_member='+filter_member+'&filter_package='+filter_package+'&filter_status='+filter_status+'&filter_submit=', '_blank');
		 if (win) {
		     win.focus();
		 } else {
		     alert('Please allow popups for this website');
		 }
	});
});

$(document).ready(function(){
	$('#export_package').on('click',function(){
		var base_url = $("#base_url").val();
		var lang = $("#lang").val();
		var filter_package = $("#filter_package").val();
		var filter_date = $("#filter_date").val();
		 var win = window.open(base_url+lang+'/package-print?filter_package='+filter_package+'&filter_date='+filter_date+'&filter_submit=', '_blank');
		 if (win) {
		     win.focus();
		 } else {
		     alert('Please allow popups for this website');
		 }
	});
});
   
