<?php
/**
 * Created by PhpStorm.
 * User: Mojtaba
 * Date: 9/15/2015
 * Time: 8:30 PM
 * Project: NodCMS
 * Website: http://www.nodcms.com
 */
defined('BASEPATH') OR exit('No direct script access allowed');
class Nodcms_general extends NodCMS_Controller
{

    function __construct()
    {
        parent::__construct('frontend');
    }

    // Set system language from URL
    public function preset($lang)
    {
        $language = $this->NodCMS_general_model->getLanguageByCode($lang);
        if ($language != 0) {
            $_SESSION["language"] = $language;
            $this->data["lang"] = $lang;
        } else {
            $language = $this->NodCMS_general_model->getLanguageDefault();
            if ($language != 0) {
                redirect(base_url() . $language["code"]);
            } else {
                exit("Didn't found eny language!");
            }
        }
        $this->lang->load($lang, $language["language_name"]);
        $_SERVER['DOCUMENT_ROOT'] = dirname(dirname(dirname(__FILE__)));
        $this->data['lang_url'] = $_SERVER["REQUEST_URI"];
        $this->data['action'] = $_SERVER["REQUEST_URI"];
        $this->data['redirect'] = $_SERVER["REQUEST_URI"];

        $this->data['settings'] = $this->NodCMS_general_model->getWebsiteInfo();
        $this->data['settings']["options"] = $this->NodCMS_general_model->getWebsiteInfoOptions($language["language_id"]);
        $this->data['settings']["company"] = isset($this->data['settings']["options"]["company"]) ? $this->data['settings']["options"]["company"] : $this->data['settings']["company"];
        $_SESSION['settings'] = $this->data['settings'];

        frontendStatisticCalc($this, $language);

        $this->data['languages'] = $this->NodCMS_general_model->getLanguages();
        foreach ($this->data['languages'] as &$value) {
            $url_array = explode("/", $this->data["lang_url"]);
            $url_array[array_search($lang, $url_array)] = $value["code"];
            $value["lang_url"] = implode("/", $url_array);
        }

        $this->data['link_contact'] = base_url() . "contact";
    }

    // Homepage
    function index($lang = null, $logout = null)
    {
        $this->preset($lang);
        if (isset($_SESSION["user"]["user_id"])) redirect(base_url() . $lang . '/dashboard');

        if ($logout != null) {
            unset($_SESSION["user"]);
            redirect(base_url() . $lang . "/home");
        }
        
        $cpanel_info = $this->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        if($cpanel_info->view_mobile==0){
            $useragent=$_SERVER['HTTP_USER_AGENT'];
            if(preg_match('/android|avantgo|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|e\-|e\/|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(di|rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|xda(\-|2|g)|yas\-|your|zeto|zte\-/i',substr($useragent,0,4))){
                redirect(base_url() . '/404.html');
            }
        }
        
        if (isset($_POST["data"]) && isset($_POST["data"]["email"]) && isset($_POST["data"]["password"])) {
            if ($_POST["data"]["email"] != "" && $_POST["data"]["password"] != "") {
                $user = $this->NodCMS_general_model->getUserByEmailAndPassword($_POST["data"]["email"], md5($_POST["data"]["password"]));
                if ($user != 0) {
                    $_SESSION["user"] = $user;
                    if (isset($_POST["data"]["keep_login"]) && $_POST["data"]["keep_login"]) {
                        $time = time();
                        setcookie("keep_login[0]", md5($user["email"]), 0, "~", base_url());
                        setcookie("keep_login[1]", md5($time), 0, "~", base_url());
                        $this->NodCMS_general_model->updateUserLogin($user["user_id"], md5($time), $_SESSION["HTTP_USER_AGENT"]);
                    }
                    redirect(base_url() . $lang . '/dashboard');
                } else {
                    $error = _l("Username or password not correct", $this);
                }
            } else {
                $error = _l("Username and password cannot be empty", $this);
            }
        }
        $this->data['login_error'] = isset($error) ? $error : null;
        $this->data['title'] = _l('Login', $this);
        $this->data['content'] = $this->load->view($this->mainTemplate . '/home', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }



    // Login page
    function login($lang, $logout = null)
    {
        $this->preset($lang);
        if ($logout != null) {
            unset($_SESSION["user"]);
            redirect(base_url() . $lang);
        }
        if (isset($_POST["data"]) && isset($_POST["data"]["email"]) && isset($_POST["data"]["password"])) {
            if ($_POST["data"]["email"] != "" && $_POST["data"]["password"] != "") {
                $user = $this->NodCMS_general_model->getUserByEmailAndPassword($_POST["data"]["email"], md5($_POST["data"]["password"]));
                if ($user != 0) {
                    $_SESSION["user"] = $user;
                    if (isset($_POST["data"]["keep_login"]) && $_POST["data"]["keep_login"]) {
                        $time = time();
                        setcookie("keep_login[0]", md5($user["email"]), 0, "~", base_url());
                        setcookie("keep_login[1]", md5($time), 0, "~", base_url());
                        $this->NodCMS_general_model->updateUserLogin($user["user_id"], md5($time), $_SESSION["HTTP_USER_AGENT"]);
                    }
                    redirect(base_url() . $lang);
                } else {
                    $error = _l("Username or password not correct", $this);
                }
            } else {
                $error = _l("Username and password cannot be empty", $this);
            }
        }
        $this->data['login_error'] = isset($error) ? $error : null;
        $this->data['title'] = _l('Login', $this);
        $this->data['content'] = $this->load->view($this->mainTemplate . '/login', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }

    // SignUp/Register page
    function register($lang)
    {
        $this->preset($lang);
        if (isset($_SESSION["user"]["user_id"])) redirect(base_url());
        if (isset($_POST["email"])) {
            $data = ($_REQUEST) ? $_REQUEST :'';
            if ($_POST["email"] != "" && preg_match("/^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,8})$/", $_POST['email'])) {
                if ($this->NodCMS_general_model->checkEmailExists($_POST["email"])) {
                    $this->session->set_flashdata('message_error', _l("This email already exists, choose another email address or click on forget password.", $this));
                } else {
                    $make_username = explode("@", $_POST["email"]);
                    $new_username = $make_username[0];
                    while ($this->NodCMS_general_model->checkUsernameExists($new_username)) {
                        $new_username = $make_username[0] . rand(1000, 8989);
                    }
                    $active_code = md5(substr(md5(time()), 4, 6));
                    $email_hash = md5($_POST["email"]);
                    if ($this->NodCMS_general_model->checkEmailExists($_POST["email"], false)) {
                        $user = array("email_hash" => $email_hash, "active_code" => $active_code, "reset_pass_exp" => time() + 18000);
                        $this->NodCMS_general_model->updateUserByEmail($user, $_POST["email"]);
                    } else {
                        $user = array(
                            "email" => $_POST["email"],
                            "username" => $new_username,
                            "active_code" => $active_code,
                            "email_hash" => $email_hash,
                            "created_date" => time(),
                            "reset_pass_exp" => time() + (18000),
                            "group_id" => 3,
                            "active_register" => 0,
                            "active" => 1
                        );
                        $this->NodCMS_general_model->insertUser($user);
                    }
                    $search = array('[--$company--]', '[--$date--]', '[--$username--]', '[--$email--]', '[--$cdate--]', '[--$refurl--]');
                    $replace = array($this->data['settings']["company"], my_int_date(time()), $user['username'], $user['email'], $user['created_date'], base_url() . $lang . '/active_account/' . $user['email_hash'] . '/' . $user['active_code']);
                    $body_data = str_replace($search, $replace, $this->data['settings']['options']['msg_reset_pass']);
                    $email_body = $this->load->view('nodcms_general/email-template-public', array('body' => $body_data), true);
                    $this->sendEmailAutomatic($_POST["email"], _l("Confirm your account", $this), $email_body);
                    $this->session->set_flashdata('message_success', _l("We send you a link to your email, please check your email inbox and spam, and flow that.", $this));
                    redirect(base_url() . $lang . "/register?success");
                }
            } else {
                $this->session->set_flashdata('message_error', _l("Please insert the correct email address", $this));
            }
        }
        $this->data['title'] = 'Register';
        $this->data['content'] = $this->load->view($this->mainTemplate . '/register', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }

    // Page for restoring password
    function forgetPassword($lang)
    {
        $this->preset($lang);
        if (isset($_SESSION["user"]["user_id"])) redirect(base_url());
        if (isset($_POST["email"])) {
            if ($_POST["email"] != "" && preg_match("/^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,8})$/", $_POST['email'])) {
                if ($this->NodCMS_general_model->checkEmailExists($_POST["email"])) {
                    $active_code = md5(substr(md5(time()), 4, 6));
                    $user = array("active_code" => $active_code, "active" => 0, "reset_pass_exp" => time() + 18000);
                    $this->NodCMS_general_model->updateUserByEmail($user, $_POST["email"]);

                    $user_info = $this->NodCMS_general_model->QuerySingleRow('users', array('email' => $_POST["email"]));

                    //Send email
                    $search = array('[--$username--]', '[--$refurl--]');
                    $replace = array($user_info->fullname, base_url() . $lang . '/reset-password/' . md5($_POST["email"]) . "/" . $active_code);
                    $body_data = str_replace($search, $replace, $this->data['settings']['options']['msg_reset_pass']);
                    $email_body = $this->load->view('nodcms_general/email-template-public', array('body' => $body_data), true);
                    $this->sendEmailAutomatic($_POST["email"], _l("Password reset request", $this), $email_body);
                    $this->session->set_flashdata('message_success', _l("We send you a link to your email, please check your email inbox and spam, and flow that.", $this));
                    redirect(base_url() . $lang);
                } else {
                    $this->session->set_flashdata('message_error', _l("Your account is not yet activated. Please check your email to activate your account.", $this));
                }
            } else {
                $this->session->set_flashdata('message_error', _l("Please insert the correct email address", $this));
            }
            redirect(base_url() . $lang . "/forget-password");
        }
        $this->data['title'] = _l('Forget password', $this);
        $this->data['content'] = $this->load->view($this->mainTemplate . '/forget_password', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }

    // Set new password for users after restoring request
    function resetPassword($lang, $email_hash, $active_code)
    {
        $this->preset($lang);
        if ($email_hash != null && $active_code != null) {
            $user = $this->NodCMS_general_model->getUserByEmailHashAndActiveCode($email_hash, $active_code);
            if (isset($user) && $user["reset_pass_exp"] > time() && ($user["active"] == 0 || $user["active_register"] == 0)) {
                $this->data['data'] = $user;
                if (isset($_POST["password"])) {
                    $redirect = $user["active_register"] == 0 ? "active_account" : "reset-password";
                    if (strlen($_POST["password"]) > 5 && strlen($_POST["password"]) < 13) {
                        if (isset($_POST["confirm_password"]) && $_POST["confirm_password"] == $_POST["password"]) {
                            $this->NodCMS_general_model->userSetNewPassword($user["user_id"], md5($_POST["password"]));
                            // Send email
                            $search = array('[--$username--]', '[--$siteurl--]');
                            $replace = array($user['fullname'], base_url() . $lang);
                            $body_data = str_replace($search, $replace, $this->data['settings']['options']['msg_active']);
                            $email_body = $this->load->view('nodcms_general/email-template-public', array('body' => $body_data), true);
                            $this->sendEmailAutomatic($user["email"], _l("Password reset successfully", $this), $email_body);

                            $this->session->set_flashdata('message_success', _l("Your account is active now.", $this));
                            redirect(base_url() . $lang . "/dashboard");
                        } else {
                            $this->session->set_flashdata('message_error', _l("Password not match", $this));
                        }
                    } else {
                        $this->session->set_flashdata('message_error', _l("Password not match", $this));
                    }
                    redirect(base_url() . $lang . "/" . $redirect . "/" . $email_hash . "/" . $active_code);
                }
            } else {
                show_404();
            }
        }
        $this->data['title'] = _l("Set password", $this);
        $this->data['content'] = $this->load->view($this->mainTemplate . '/reset_password', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }

    // User change password page
    function profilePassword($lang)
    {
        $this->preset($lang);
        if (isset($_SESSION['user'])) {
            if (isset($_POST['old_password']) && isset($_POST['password']) && isset($_POST['confirm_password'])) {
                if ($_POST['old_password'] != "" && $_POST['password'] != "" && strlen($_POST['password']) > 5 && strlen($_POST['password']) < 13 && $_POST['password'] = $_POST['confirm_password']) {
                    if ($_SESSION['user']['password'] == md5($_POST['old_password'])) {
                        $this->NodCMS_general_model->userEditPassword($_SESSION['user']['user_id'], md5($_POST['password']));
                        $this->session->set_flashdata('message_success', _l("Password changed", $this));
                    } else {
                        $this->session->set_flashdata('old_password_error', _l("Last password not correct", $this));
                    }
                } else {
                    $this->session->set_flashdata('error', _l("Inserted data not correct", $this));
                }
                redirect(base_url() . $lang . "/profile-password", 'refresh');
            }
            $this->data['title'] = _l('Change password', $this);
            $this->data['page_type'] = _l('change_password', $this);
            $this->data['content'] = $this->load->view($this->mainTemplate . '/profilepassword', $this->data, true);
            $this->load->view($this->mainTemplate, $this->data, '');
        } else {
            $_SESSION['redirect_page'] = "profile-password";
            redirect('/dashboard', 'refresh');
        }
    }

    
    /*
     * This private method just used in this document
     * It used to send notification emails to users
     */
    private function sendEmailAutomatic($emails, $subject, $content, $from = null,$attachment = null, $cc_emails = null)
    {
        if ($_SERVER['SERVER_NAME'] != 'localhost') {
            $setting = $this->data['settings'];
            if (isset($setting['use_smtp']) && $setting['use_smtp'] == 1) {
                $config = array(
                    'protocol' => 'smtp',
                    'smtp_host' => $setting['smtp_host'],
                    'smtp_port' => $setting['smtp_port'],
                    'smtp_user' => $setting['smtp_username'],
                    'smtp_pass' => $setting['smtp_password'],
                    'mailtype' => 'html',
                    'charset' => 'iso-8859-1',
                    'starttls' => true,
                    'newline' => "\r\n"
                );
            } else {
                $config = array(
                    'protocol' => 'mail',
                    'mailtype' => 'html',
                    'charset' => 'utf8',
                    'starttls' => true,
                    'newline' => "\r\n"
                );
            }
            $this->load->library('email', $config);
            //$this->email->initialize($config);
            try {
                $this->email->clear(TRUE);
                $this->email->to($emails);

                if ($from == NULL) {
                    $this->email->from($setting['email'], $setting['company']);
                } else {
                    $this->email->from($from);
                }
                $this->email->subject($subject);
                $this->email->message($content);
                if ($cc_emails != NULL) {
                	$this->email->cc($cc_emails);
                }
                if ($attachment != NULL) {
                    $this->email->attach($attachment);
                }                
                $this->email->send();
                return true;
            } catch (Exception $e) {
                //Do nothing
                print_r($e);
                die;
            }
        }
    }

    // XML site map page (sitemap.xml)
    function siteMapXML($lang)
    {
        $this->preset($lang);
        $this->data['extensions'] = $this->NodCMS_general_model->searchExtension(array());
        $this->load->view('sitemap', $this->data, '');
    }

    // XML feed page
    function rss($lang)
    {
        $this->preset($lang);
        $this->data['extensions'] = $this->NodCMS_general_model->searchExtension(array());
        $this->load->view('rss', $this->data, '');
    }

    // Dashboard view
    function dashboard($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    	
    	if(GetPermission('dashboard')==0){
    		redirect(base_url() . $lang . "/access-denied", 'refresh');
    	}
    	
    	$cpanel_info = $this->NodCMS_general_model->QuerySingleRow('cpanel',array("id"=>1));
        $this->data['cpanel_info'] = $cpanel_info; 
    	
    	$this->data['total_members'] = $this->NodCMS_general_model->RowCount('members',array('status'=>1));
    	$this->data['inactive_members'] = $this->NodCMS_general_model->RowCount('members',array('status'=>0));
    	$this->data['employees'] = $this->NodCMS_general_model->RowCount('trainees');
		$this->data['recent_payments'] = $this->NodCMS_general_model->QueryLimit('payment','',10,'id','DESC');
		$events = array();
    	$active_members = $this->NodCMS_general_model->GetExpirePaymentReport(array('is_add_on'=>0,''),'active');
    	//P($active_members,1);
    	$this->data['active_member_count'] = 0;
		if($active_members){
			$sno = 0;
			foreach ($active_members as $active_member){
				$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$active_member['package_id']));
				$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$active_member['member_id']));
				if(($member_info->status==1) && ($package_info->package_type==1)){
					$sno++;	
				}
			}
			$this->data['active_member_count'] = $sno;
		}
		
		$expire_proofs = $this->NodCMS_general_model->GetExpireProof();
		
		if($expire_proofs){
			foreach ($expire_proofs as $expire_proof){
				$member_info = $this->NodCMS_general_model->QuerySingleRow('employees',array('id'=>$expire_proof['employee_id']));
				$now = time(); // or your date as well
				$your_date = strtotime($expire_proof['expire_date']);
				$datediff = $your_date - $now;
				
				$no_days = round($datediff / (60 * 60 * 24));
				if($no_days>0){
					$description = 'Document Expire within '.$no_days.' Days';
				}else{
					$description = 'Document Expire Today';
				}
				$events[] = array('title'=>$member_info->name,'descrption'=>$description,'date'=>$expire_proof['expire_date'],'type'=>'document');
			}
		}
		
		
		$this->data['alert_count'] = 0;
		$expire_payments = $this->NodCMS_general_model->GetExpirePayment();
		
		if($expire_payments){
			$sno = 0;
			foreach ($expire_payments as $expire_payment){
				$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$expire_payment['member_id']));
				$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$expire_payment['package_id']));
				$now = time(); // or your date as well
				$your_date = strtotime($expire_payment['expire_date']);
				$datediff = $your_date - $now;
				
				if($package_info->package_type==1){
					$no_days = round($datediff / (60 * 60 * 24));
					if($no_days>0){
						$description = 'Package Expire within '.$no_days.' Days';
					 }elseif($no_days==0){
						$description = '<span class="text-red">Package Expire Today</span>';
					 }else{
					 	
					 	$description = 'Package has Expired '.NumberToDate(-1*$no_days).' ago';
					 }
					if($expire_payment['expire_date']!='0000-00-00') { $dd = 'Expire Date :'.date_to_Display(strtotime($expire_payment['expire_date'])); }else{ $dd = ''; }
					$description .= '<br>'.$package_info->package_name.' <br> '.$dd;
					$sno++;
					$events[] = array('member_info'=>$member_info,'payment_info'=>$expire_payment, 'descrption'=>$description,'date'=>$expire_payment['expire_date'],'type'=>'payment');
				}
			}
			$this->data['alert_count'] = $sno;
		}
		
		$expire_payments = $this->NodCMS_general_model->GetExpireAddPayment();
		/*echo '<pre>';
			print_r($expire_payments);
		echo '</pre>';die();*/
		if($expire_payments){
			foreach ($expire_payments as $expire_payment){
				$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$expire_payment['member_id']));
				$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$expire_payment['package_id']));
				$now = time(); // or your date as well
				$your_date = strtotime($expire_payment['expire_date']);
				$datediff = $your_date - $now;
				if($package_info->package_type==1){
					$no_days = round($datediff / (60 * 60 * 24));
					if($no_days>0){
						$description = 'AddOn Package Expire within '.$no_days.' Days';
					 }elseif($no_days==0){
						$description = '<span class="text-red">AddOn Package Expire Today</span>';
					 }else{
					 	
					 	$description = 'AddOn Package has Expired '.NumberToDate(-1*$no_days).' ago';
					 }
					if($expire_payment['expire_date']!='0000-00-00') { $dd = 'Expire Date :'.date_to_Display(strtotime($expire_payment['expire_date'])); }else{ $dd = ''; }
					$description .= '<br>'.$package_info->package_name.' <br> '.$dd;
					$events[] = array('member_info'=>$member_info,'payment_info'=>$expire_payment, 'descrption'=>$description,'date'=>$expire_payment['expire_date'],'type'=>'payment_addon');
				}
			}
		}
		
		
		/*$pending_payments = $this->NodCMS_general_model->GetPendingPayment();
		if($pending_payments){
			foreach ($pending_payments as $pending_payment){
				$booking_info = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$pending_payment['booking_id']));
				if($booking_info){
					if($booking_info->amount != $pending_payment['total']){
						$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$pending_payment['member_id']));
						$description = 'balance amount is '.PriceFormat(($booking_info->amount-$pending_payment['total']));
						$events[] = array('title'=>$member_info->member_name,'descrption'=>$description,'date'=>$expire_payment['expire_date'],'type'=>'pending');
					}
				}
			}
		}*/
		
		$pending_payments = $this->NodCMS_general_model->QueryArray("booking",array("status"=>1));
		if($pending_payments){
			foreach ($pending_payments as $pending_payment){
				$payment_info = $this->NodCMS_general_model->GetPendingPayment(array("booking_id"=>$pending_payment['id'],"member_id"=>$pending_payment['member_id'],'package_id'=>$pending_payment['package_id']));
				if($payment_info){
					$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$pending_payment['member_id']));
					$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$pending_payment['package_id']));
					if(($pending_payment['amount']-$payment_info->total)>0){
						if($payment_info->total != $pending_payment['amount']){
							$description = 'balance amount is '.PriceFormat(($pending_payment['amount']-$payment_info->total));
							if($pending_payment['expire_date']!='0000-00-00') { $dd = 'Expire Date :'.date_to_Display(strtotime($pending_payment['expire_date'])); }else{ $dd = ''; }
							$description .= '<br>'.$package_info->package_name.' <br>  '.$dd;
							$events[] = array('member_info'=>$member_info,'booking_info'=>$pending_payment,'descrption'=>$description,'date'=>$pending_payment['expire_date'],'type'=>'pending');
						}else{
							$description = 'balance amount is '.PriceFormat($pending_payment['amount']);
							if($pending_payment['expire_date']!='0000-00-00') { $dd = 'Expire Date :'.date_to_Display(strtotime($pending_payment['expire_date'])); }else{ $dd = ''; }
							$description .= '<br>'.$package_info->package_name.' <br> '.$dd;
							$events[] = array('member_info'=>$member_info,'booking_info'=>$pending_payment,'descrption'=>$description,'date'=>$pending_payment['expire_date'],'type'=>'pending');
						}
					}
				}
			}
		}
		
		
		
		$this->data['events'] = $events;
		$this->data['payment_total'] = '';
		$payment_total = array();
		$search_by_year = date("Y");
		if(isset($_REQUEST['search_by_year'])){
			$search_by_year = $_REQUEST['search_by_year'];
		}
		$total_payments = $this->NodCMS_general_model->TotalPayment($search_by_year);
		//print_r($total_payments);die();
		if($total_payments){
			foreach ($total_payments as $total_payment) {
				$payment_total[$total_payment['month']] = $total_payment['total'];
			}
		}
		$payment_total_month = array();
		
		for($i=1;$i<=12;$i++){
			if(array_key_exists($i,$payment_total)){
				$payment_total_month[$i] = $payment_total[$i]; 	
			}else{
				$payment_total_month[$i] = 0;
			}
		}
		$this->data['payment_total'] = $payment_total_month;
		
		$expense_total = array();
		$this->data['expense_total'] = '';
		$total_expenses = $this->NodCMS_general_model->TotalExpense($search_by_year);
		if($total_expenses){
			foreach ($total_expenses as $total_expense) {
				$expense_total[$total_expense['month']] = $total_expense['total'];
			}
		}
		$expense_total_month = array();
		if($expense_total){
		
			for($i=1;$i<=12;$i++){
				if(array_key_exists($i,$expense_total)){
					$expense_total_month[$i] = $expense_total[$i]; 	
				}else{
					$expense_total_month[$i] = 0;
				}
			}
		}
		$this->data['expense_total'] = $expense_total_month;
		
        $this->data['title'] = _l('Dashboard', $this);
        $this->data['page_type'] = "dashboard";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/dashboard', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }

    // customers view
    function Members($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    	
    	$search_filter = (isset($_REQUEST['filter_status'])) ? $_REQUEST['filter_status'] : '';
    	
    	if($search_filter!='*'){
    		$where = array('status'=>$search_filter);
    	}else{
    		$where = array('');
    	}
    	
        $this->data['members'] = $this->NodCMS_general_model->QueryArray('members',$where,'member_number','ASC');
        //echo $this->db->last_query();die();
        $this->data['title'] = _l('Members', $this);
        $this->data['page_type'] = "members";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/member/members', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Member($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    	if(GetPermission('is_create')==0){
    		redirect(base_url() . $lang . "/access-denied", 'refresh');
    	}
        if(isset($_REQUEST['save_member'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	//echo '<pre>'.print_r($data).'</pre>';die();
        	
        	if($data['sms_message']!=''){
        		SendSMS($data['contact_number'],$data['sms_message']);
        	}
        	
        	if($_FILES["file_input"]["name"]){
	        	$target_dir = "upload/users/";
				$target_file = $target_dir . time().'_'.basename($_FILES["file_input"]["name"]);
				$uploadOk = 1;
				$imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
				
		        $check = getimagesize($_FILES["file_input"]["tmp_name"]);
			    if($check !== false) {
			        //$this->session->set_flashdata('message_error', _l("File is an image - " . $check["mime"] . ".", $this));
			        $uploadOk = 1;
			    } else {
			        $this->session->set_flashdata('message_error', _l("File is not an image.", $this));
			        $uploadOk = 0;
			    }
			    
	        	if (file_exists($target_file)) {
				    $this->session->set_flashdata('message_error', _l("Sorry, file already exists.", $this));
				    $uploadOk = 0;
				}
				if ($_FILES["file_input"]["size"] > 500000) {
				    $this->session->set_flashdata('message_error', _l("Sorry, your file is too large.", $this));
				    $uploadOk = 0;
				}
				if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
				&& $imageFileType != "gif" ) {
				    $this->session->set_flashdata('message_error', _l("Sorry, only JPG, JPEG, PNG & GIF files are allowed.", $this));
				    $uploadOk = 0;
				}
				// Check if $uploadOk is set to 0 by an error
				if ($uploadOk == 0) {
				    $this->session->set_flashdata('message_error', _l("Sorry, your file was not uploaded.", $this));
				} else {
				    if (move_uploaded_file($_FILES["file_input"]["tmp_name"], $target_file)) {
				        //echo "The file ". basename( $_FILES["file_input"]["name"]). " has been uploaded.";
				    } else {
				        $this->session->set_flashdata('message_error', _l("Sorry, there was an error uploading your file.", $this));
				    }
				}
        	}else{
        		$target_file = '';
        	}

	        	if($data){
	        		$args = array(
	        			'member_number'		=> GenerateMemberNo(),
	        			'member_name' 		=> $data['member_name'],
		        		'member_email' 		=> $data['member_email'],
		        		'contact_number' 	=> $data['contact_number'],
	        			'emirates_id' 		=> $data['emirates_id'],
	        			'image_url'			=> $target_file,
		        		'dob' 				=> date_to_DB(strtotime($data['dob'])),
	        			'doj' 				=> date_to_DB(strtotime($data['doj'])),
		        		'gender' 			=> $data['gender'],
		        		'address' 			=> $data['address'],
		        		'country' 			=> $data['country'],
		        		'state' 			=> $data['state'],
		        		'city' 				=> $data['city'],
	        			'zip' 				=> $data['zip'],
		        		'created_on' 		=> strtotime(date("Y-m-d")),
		        		'status' 			=> $data['status']        		
	        		);
	        		$count = $this->NodCMS_general_model->Count('members',array('contact_number'=>$data['contact_number']),array('emirates_id'=>$data['emirates_id']));
	        		if($count>0){
	        			$this->session->set_flashdata('message_error', _l("Contact Number or Emirates ID Already Exist", $this));
	        		}else{
	        			$insert_member = $this->NodCMS_general_model->InsertRow('members',$args);
	        			$last_id = $this->NodCMS_general_model->InsertedID();
	        			if($insert_member){
	        				$this->session->set_flashdata('message_success', _l("Member Inserted Successfully", $this));
		        			if(GetPermission('is_edit')==0){
					    		redirect(base_url() . $lang . "/members", 'refresh');
					    	}else{
	        					redirect(base_url() . $lang . "/member?e_id=".$last_id, 'refresh');
					    	}
	        			}
	        		}
	        		
        		redirect(base_url() . $lang . "/members", 'refresh');
        	}
        }
        
        if(isset($_REQUEST['e_id'])){
	        if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        	$this->data['member_info'] = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$_REQUEST['e_id']));
        }else{
        	$this->data['member_info'] = '';
        }

        
    if(isset($_REQUEST['update_member'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	//echo '<pre>'.print_r($data).'</pre>';die();
        	
    		if($data['sms_message']!=''){
        		SendSMS($data['contact_number'],$data['sms_message']);
        	}
        	
        	if($_FILES["file_input"]["name"]!=''){
	        	$target_dir = "upload/users/";
				$target_file = $target_dir . time().'_'.basename($_FILES["file_input"]["name"]);
				$uploadOk = 1;
				$imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
				
		        $check = getimagesize($_FILES["file_input"]["tmp_name"]);
			    if($check !== false) {
			        //$this->session->set_flashdata('message_error', _l("File is an image - " . $check["mime"] . ".", $this));
			        $uploadOk = 1;
			    } else {
			        $this->session->set_flashdata('message_error', _l("File is not an image.", $this));
			        $uploadOk = 0;
			    }
			    
	        	if (file_exists($target_file)) {
				    $this->session->set_flashdata('message_error', _l("Sorry, file already exists.", $this));
				    $uploadOk = 0;
				}
				if ($_FILES["file_input"]["size"] > 500000) {
				    $this->session->set_flashdata('message_error', _l("Sorry, your file is too large.", $this));
				    $uploadOk = 0;
				}
				if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
				&& $imageFileType != "gif" ) {
				    $this->session->set_flashdata('message_error', _l("Sorry, only JPG, JPEG, PNG & GIF files are allowed.", $this));
				    $uploadOk = 0;
				}
				// Check if $uploadOk is set to 0 by an error
				if ($uploadOk == 0) {
				    $this->session->set_flashdata('message_error', _l("Sorry, your file was not uploaded.", $this));
				} else {
				    if (move_uploaded_file($_FILES["file_input"]["tmp_name"], $target_file)) {
				        //echo "The file ". basename( $_FILES["file_input"]["name"]). " has been uploaded.";
				    } else {
				        $this->session->set_flashdata('message_error', _l("Sorry, there was an error uploading your file.", $this));
				    }
				}
        	}else{
        		$uploadOk = 0;
        	}

	        	if($data){
	        		if($uploadOk==0){
		        		$args = array(
		        			'member_name' 		=> $data['member_name'],
			        		'member_email' 		=> $data['member_email'],
			        		'contact_number' 	=> $data['contact_number'],
		        			'emirates_id' 		=> $data['emirates_id'],
		        			'dob' 				=> date_to_DB(strtotime($data['dob'])),
		        			'doj' 				=> date_to_DB(strtotime($data['doj'])),
			        		'gender' 			=> $data['gender'],
			        		'address' 			=> $data['address'],
			        		'country' 			=> $data['country'],
			        		'state' 			=> $data['state'],
			        		'city' 				=> $data['city'],
		        			'zip' 				=> $data['zip'],
			        		'created_on' 		=> strtotime(date("Y-m-d")),
			        		'status' 			=> $data['status']        		
		        		);
	        		}else{
	        			$args = array(
		        			'member_name' 		=> $data['member_name'],
			        		'member_email' 		=> $data['member_email'],
			        		'contact_number' 	=> $data['contact_number'],
	        				'emirates_id' 		=> $data['emirates_id'],
		        			'image_url'			=> $target_file,
			        		'dob' 				=> date_to_DB(strtotime($data['dob'])),
		        			'doj' 				=> date_to_DB(strtotime($data['doj'])),
			        		'gender' 			=> $data['gender'],
			        		'address' 			=> $data['address'],
			        		'country' 			=> $data['country'],
			        		'state' 			=> $data['state'],
			        		'city' 				=> $data['city'],
		        			'zip' 				=> $data['zip'],
			        		'created_on' 		=> strtotime(date("Y-m-d")),
			        		'status' 			=> $data['status']        		
		        		);
	        		}
	        		$count = $this->NodCMS_general_model->CountSingleValue('members',array('contact_number'=>$data['contact_number']),array('emirates_id'=>$data['emirates_id']));
	        		
	        		if($count){
	        			if($count->id!=$data['member_id']){
		        			$this->session->set_flashdata('message_error', _l("Contact Number or Emirates ID Already Exist", $this));
		        		}else{
							$update_member = $this->NodCMS_general_model->UpdateRow('members',$args,array('id'=>$data['member_id']));
		        			if($update_member){
		        				$this->session->set_flashdata('message_success', _l("Member Updated Successfully", $this));
		        			}
		        		}
	        		}
	        	}	
        		redirect(base_url() . $lang . "/member?e_id=".$data['member_id'], 'refresh');
        }
        
        $this->data['sms_messages'] = $this->NodCMS_general_model->QueryArray('smstemplates',array('category'=>1));
        $this->data['sms_config'] = $this->NodCMS_general_model->QuerySingleRow('smscategory',array('id'=>1));
        
        $this->data['title'] = _l('Add Member', $this);
        $this->data['page_type'] = "members";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/member/member', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function PrintMember($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    	if(GetPermission('is_create')==0){
    		redirect(base_url() . $lang . "/access-denied", 'refresh');
    	}
        
    	if(isset($_REQUEST['e_id'])){
	        if(GetPermission('is_edit')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        	$this->data['member_info'] = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$_REQUEST['e_id']));
        }else{
        	$this->data['member_info'] = '';
        }
        
        $this->data['company'] = $this->NodCMS_general_model->QuerySingleRow('company',array('id'=>1));
        
        $this->data['title'] = _l('Add Member', $this);
        $this->data['page_type'] = "print-member";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/print_member', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function ReportPackage($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $member_list = '';
        	$package_list = '';
        	$where = array();
    	$this->data['filter_data'] = '';
        if(isset($_REQUEST['filter_submit'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	$this->data['filter_data'] = $data;
        	
        	if($data){
        		$member_list = '';
        		$package_list = '';
        		$where = array();
        		$where['payment_status'] = 1;
        		if($data['filter_package']!=''){
        			$where['package_id'] = $data['filter_package'];
        		}
        		if($data['filter_date']!=''){
        			$dates = explode("-",$data['filter_date']);
        			$where['DATE(payment_date) >='] = date_to_DB(strtotime($dates[0]));
        			$where['DATE(payment_date) <='] = date_to_DB(strtotime($dates[1]));
        		}
        	}
        }else{
        	$where['DATE(payment_date)'] = date("Y-m-d");
        }
    	
        $this->data['package_reports'] = $package_reports = $this->NodCMS_general_model->PaymentResult($where);
        $this->data['packages'] = $package_reports = $this->NodCMS_general_model->QueryArray("package",array('published'=>1));
        /*echo '<pre>';
        	print_r($package_reports);
        echo '</pre>';die();*/
        $this->data['title'] = _l('Package Report', $this);
        $this->data['page_type'] = "report-package";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/package_report', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function PackagePrint($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    	$member_list = '';
        	$package_list = '';
        	$where = array();
    	$this->data['filter_data'] = '';
        if(isset($_REQUEST['filter_submit'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	$this->data['filter_data'] = $data;
        	
        	if($data){
        		$member_list = '';
        		$package_list = '';
        		$where = array();
        		$where['payment_status'] = 1;
        		if($data['filter_package']!=''){
        			$where['package_id'] = $data['filter_package'];
        		}
        		if($data['filter_date']!=''){
        			$dates = explode("-",$data['filter_date']);
        			$where['DATE(payment_date) >='] = date_to_DB(strtotime($dates[0]));
        			$where['DATE(payment_date) <='] = date_to_DB(strtotime($dates[1]));
        		}
        	}
        }else{
        	$where['DATE(payment_date)'] = date("Y-m-d");
        }
        
    	
        $this->data['package_reports'] = $package_reports = $this->NodCMS_general_model->PaymentResult($where);
         $this->data['company'] = $this->NodCMS_general_model->QuerySingleRow('company',array('id'=>1));
        $this->data['title'] = _l('Package Report', $this);
        $this->data['page_type'] = "package-print";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/print_package', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Trainees($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $this->data['trainees'] = $this->NodCMS_general_model->QueryArray('trainees');
        
        $this->data['title'] = _l('Trainees', $this);
        $this->data['page_type'] = "trainees";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/trainee/trainees', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Trainee($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        
    if(GetPermission('is_create')==0){
    		redirect(base_url() . $lang . "/access-denied", 'refresh');
    	}
    	
        if(isset($_REQUEST['save_trainee'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	//echo '<pre>'.print_r($data).'</pre>';die();
        	if($data){
        		$args = array(
        			'name' 			=> $data['name'],
	        		'email' 		=> $data['email'],
	        		'phone_number' 	=> $data['phone_number'],
	        		'address' 		=> $data['address'],
	        		'published' 	=> 1,
	        		'user_id' 		=> $_SESSION['user']['user_id']
        		);
        		
        			$insert_member = $this->NodCMS_general_model->InsertRow('trainees',$args);
        			if($insert_member){
        				$this->session->set_flashdata('message_success', _l("Trainee Inserted Successfully", $this));
        				
        			}
        		
        		redirect(base_url() . $lang . "/trainee", 'refresh');
        	}
        }
        
    	if(isset($_REQUEST['e_id'])){
    		if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        	$this->data['trainee_info'] = $this->NodCMS_general_model->QuerySingleRow('trainees',array('id'=>$_REQUEST['e_id']));
        }else{
        	$this->data['trainee_info'] = '';
        }
        
    	if(isset($_REQUEST['update_trainee'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		$args = array(
        			'name' 			=> $data['name'],
	        		'email' 		=> $data['email'],
	        		'phone_number' 	=> $data['phone_number'],
	        		'address' 		=> $data['address'],
	        		'published' 	=> 1,
	        		'user_id' 		=> $_SESSION['user']['user_id']
        		);
        		
				$update_member = $this->NodCMS_general_model->UpdateRow('trainees',$args,array('id'=>$data['trainee_id']));
        		if($update_member){
        			$this->session->set_flashdata('message_success', _l("Trainee Updated Successfully", $this));
        		}
        		redirect(base_url() . $lang . "/trainee", 'refresh');
        	}
        }

        $this->data['title'] = _l('Add Trainee', $this);
        $this->data['page_type'] = "trainees";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/trainee/trainee', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
    
	function Proofs($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $this->data['proofs'] = $this->NodCMS_general_model->QueryArray('prooflist');
        
        $this->data['title'] = _l('Proofs', $this);
        $this->data['page_type'] = "proofs";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/proof/proofs', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Proof($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        if(isset($_REQUEST['save_proof'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	//echo '<pre>'.print_r($data).'</pre>';die();
        	if($data){
        		$args = array(
        			'title' 		=> $data['title']
        		);
        		$count = $this->NodCMS_general_model->Count('prooflist',array('title'=>$data['title']));
        		if($count>0){
        			$this->session->set_flashdata('message_error', _l("Proof Title Already Exist", $this));
        			
        		}else{
        			$insert_member = $this->NodCMS_general_model->InsertRow('prooflist',$args);
        			if($insert_member){
        				$this->session->set_flashdata('message_success', _l("Proof Inserted Successfully", $this));
        				
        			}
        		}
        		redirect(base_url() . $lang . "/proof", 'refresh');
        	}
        }
        
    	if(isset($_REQUEST['e_id'])){
    		if(GetPermission('is_edit')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        	$this->data['proof_info'] = $this->NodCMS_general_model->QuerySingleRow('prooflist',array('id'=>$_REQUEST['e_id']));
        }else{
        	$this->data['proof_info'] = '';
        }
        
    	if(isset($_REQUEST['update_proof'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		$args = array(
        			'title' 		=> $data['title']
        		);
        		
				$update_member = $this->NodCMS_general_model->UpdateRow('prooflist',$args,array('id'=>$data['proof_id']));
        		if($update_member){
        			$this->session->set_flashdata('message_success', _l("Proof Updated Successfully", $this));
        		}
        		redirect(base_url() . $lang . "/proof", 'refresh');
        	}
        }

        $this->data['title'] = _l('Add Proof', $this);
        $this->data['page_type'] = "proofs";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/proof/proof', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
    
	function Employees($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $this->data['employees'] = $this->NodCMS_general_model->QueryArray('employees');
        
        $this->data['title'] = _l('Employees', $this);
        $this->data['page_type'] = "employees";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/employee/employees', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Employee($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        if(isset($_REQUEST['save_employee'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	//echo '<pre>'.print_r($data['proof']).'</pre>';die();
        	if($data){
        		$args = array(
        			'employee_number'=> GenerateEmployeeNo(),
        			'name' 			=> $data['name'],
	        		'email' 		=> $data['email'],
	        		'phone_number' 	=> $data['phone_number'],
	        		'is_trainee' 	=> $data['is_trainee'],
	        		'address' 		=> $data['address'],
	        		'published' 	=> 1,
	        		'user_id' 		=> $_SESSION['user']['user_id']
        		);
        		/*$count = $this->NodCMS_general_model->Count('employees',array('email'=>$data['email']),array('phone_number'=>$data['phone_number']));
        		if($count>0){
        			$this->session->set_flashdata('message_error', _l("Email or Contact Number Already Exist", $this));
        			
        		}else{ */
        			$insert_member = $this->NodCMS_general_model->InsertRow('employees',$args);
        			if($insert_member){
        				$last_id = $this->NodCMS_general_model->InsertedID();
        				
        				if(count($data['proof'])){
        					foreach($data['proof'] as $proof){
        						if($proof['proof_number']!=''){
	        						$args = array(
	        								"proof_type"	=>	$proof['proof_type'],
			        						"proof_number"	=>	$proof['proof_number'],
			        						"issue_date"	=>	date_to_DB(strtotime($proof['issue_date'])),
			        						"expire_date"	=>	date_to_DB(strtotime($proof['expire_date'])),
	        								"employee_id"	=> 	$last_id,
			        						"created_date"	=>	date("Y-m-d"),
			        						"user_id"		=>	$_SESSION['user']['user_id']
	        							);
	        						$insert_proof = $this->NodCMS_general_model->InsertRow('employee_proof',$args);
        						}
        					}
        				}        				
        				
        				if($data['is_trainee']){
        					$tarinee_args = array(
			        			'name' 			=> $data['name'],
				        		'email' 		=> $data['email'],
				        		'phone_number' 	=> $data['phone_number'],
				        		'address' 		=> $data['address'],
				        		'published' 	=> 1,
				        		'user_id' 		=> $_SESSION['user']['user_id']
			        		);
        				$insert_trainee = $this->NodCMS_general_model->InsertRow('trainees',$tarinee_args);
	        			
        				}
        				$this->session->set_flashdata('message_success', _l("Employee Inserted Successfully", $this));
        			}
        		/*}*/
        		redirect(base_url() . $lang . "/employee", 'refresh');
        	}
        }
        
    	if(isset($_REQUEST['e_id'])){
    		if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        	$this->data['employee_info'] = $this->NodCMS_general_model->QuerySingleRow('employees',array('id'=>$_REQUEST['e_id']));
        	$this->data['employee_proof'] = $this->NodCMS_general_model->QueryArray('employee_proof',array('employee_id'=>$_REQUEST['e_id']));
        }else{
        	$this->data['employee_info'] = '';
        	$this->data['employee_proof'] = '';
        }
        
    	if(isset($_REQUEST['update_employee'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		$args = array(
        			'name' 			=> $data['name'],
	        		'email' 		=> $data['email'],
	        		'phone_number' 	=> $data['phone_number'],
        			'is_trainee' 	=> $data['is_trainee'],
        			'address' 		=> $data['address'],
	        		'published' 	=> 1,
	        		'user_id' 		=> $_SESSION['user']['user_id']
        		);
        		
				$update_member = $this->NodCMS_general_model->UpdateRow('employees',$args,array('id'=>$data['employee_id']));
        		if($update_member){
        			$this->session->set_flashdata('message_success', _l("Emplyee Updated Successfully", $this));
        			
        			if(count($data['proof'])){
        				$delete_proof = $this->NodCMS_general_model->DeleteRow('employee_proof',array('employee_id'=>$data['employee_id']));
        					foreach($data['proof'] as $proof){
        						if($proof['proof_number']!=''){
	        						$args = array(
	        								"proof_type"	=>	$proof['proof_type'],
			        						"proof_number"	=>	$proof['proof_number'],
			        						"issue_date"	=>	date_to_DB(strtotime($proof['issue_date'])),
			        						"expire_date"	=>	date_to_DB(strtotime($proof['expire_date'])),
	        								"employee_id"	=> 	$data['employee_id'],
			        						"created_date"	=>	date("Y-m-d"),
			        						"user_id"		=>	$_SESSION['user']['user_id']
	        							);
	        						$insert_proof = $this->NodCMS_general_model->InsertRow('employee_proof',$args);
        						}
        					}
        				} 
        				
        			if($data['is_trainee']){
        					$tarinee_args = array(
			        			'name' 			=> $data['name'],
				        		'email' 		=> $data['email'],
				        		'phone_number' 	=> $data['phone_number'],
				        		'address' 		=> $data['address'],
				        		'published' 	=> 1,
				        		'user_id' 		=> $_SESSION['user']['user_id']
			        		);
        			$count = $this->NodCMS_general_model->Count('trainees',array('email'=>$data['email']),array('phone_number'=>$data['phone_number']));
	        		if($count>0){
	        			
	        			
	        		}else{
	        			$insert_trainee = $this->NodCMS_general_model->InsertRow('trainees',$tarinee_args);
	        			
	        		}
	        			
        				}
        		}
        		redirect(base_url() . $lang . "/employee?e_id=".$data['employee_id'], 'refresh');
        	}
        }

        $this->data['proof_list'] = $this->NodCMS_general_model->QueryArray('prooflist');
        
        $this->data['title'] = _l('Add Employee', $this);
        $this->data['page_type'] = "employees";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/employee/employee', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Groups($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $this->data['groups'] = $this->NodCMS_general_model->QueryArray('groups');
        
        $this->data['title'] = _l('Groups', $this);
        $this->data['page_type'] = "groups";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/group/groups', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Group($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        if(isset($_REQUEST['save_group'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	//echo '<pre>'.print_r($data).'</pre>';die();
        	if($data){
        		$args = array(
        			'groupname' 	=> $data['groupname'],
	        		'dashboard' 	=> $data['dashboard'],
	        		'is_create' 	=> $data['is_create'],
        			'is_view' 		=> $data['is_view'],
        			'is_edit' 		=> $data['is_edit'],
	        		'is_delete' 	=> $data['is_delete'],
        			'is_print' 		=> $data['is_print'],
	        		'status' 		=> $data['status']
        		);
        		$count = $this->NodCMS_general_model->Count('groups',array('groupname'=>$data['groupname']));
        		if($count>0){
        			$this->session->set_flashdata('message_error', _l("Group Name Already Exist", $this));
        			
        		}else{
        			$insert_member = $this->NodCMS_general_model->InsertRow('groups',$args);
        			if($insert_member){
        				$this->session->set_flashdata('message_success', _l("Group Inserted Successfully", $this));
        			}
        		}
        		redirect(base_url() . $lang . "/group", 'refresh');
        	}
        }
        
    	if(isset($_REQUEST['e_id'])){
    		if(GetPermission('is_edit')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        	$this->data['group_info'] = $this->NodCMS_general_model->QuerySingleRow('groups',array('group_id'=>$_REQUEST['e_id']));
        }else{
        	$this->data['group_info'] = '';
        }
        
    	if(isset($_REQUEST['update_group'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		$args = array(
        			'groupname' 	=> $data['groupname'],
	        		'dashboard' 	=> $data['dashboard'],
	        		'is_create' 	=> $data['is_create'],
        			'is_view' 		=> $data['is_view'],
        			'is_edit' 		=> $data['is_edit'],
	        		'is_delete' 	=> $data['is_delete'],
        			'is_print' 		=> $data['is_print'],
	        		'status' 		=> $data['status']
        		);
        		
				$update_member = $this->NodCMS_general_model->UpdateRow('groups',$args,array('group_id'=>$data['group_id']));
        		if($update_member){
        			$this->session->set_flashdata('message_success', _l("Group Updated Successfully", $this));
        			
        		}
        		redirect(base_url() . $lang . "/groups", 'refresh');
        	}
        }

        
        $this->data['title'] = _l('Add Group', $this);
        $this->data['page_type'] = "groups";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/group/group', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
    
	function Users($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $this->data['users'] = $this->NodCMS_general_model->QueryArray('users');
        
        $this->data['title'] = _l('Users', $this);
        $this->data['page_type'] = "users";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/user/users', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function User($lang)
    {
        $this->preset($lang);
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        
        $cpanel_info = $this->NodCMS_general_model->QuerySingleRow('cpanel',array("id"=>1));
        $this->data['cpanel_info'] = $cpanel_info; 
        
        if(isset($_REQUEST['save_user'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	//echo '<pre>'.print_r($data).'</pre>';die();
        	if($data){
        		if (strlen($data["password"]) >= 6) {
                        if (isset($data["confirm_password"]) && $data["confirm_password"] == $data["password"]) {
			        		$args = array(
			        			'username' 		=> $data['username'],
			        			'fullname' 		=> $data['username'],
				        		'email' 		=> $data['email'],
				        		'group_id' 	 	=> $data['group_id'],
				        		'password' 		=> md5($data['password']),
				        		'status' 		=> $data['status']
			        		);
			        		$count = $this->NodCMS_general_model->Count('users',array('username'=>$data['username']),array('email'=>$data['email']));
			        		if($count>0){
			        			$this->session->set_flashdata('message_error', _l("Username or Email Number Already Exist", $this));
			        			
			        		}else{
			        			$insert_member = $this->NodCMS_general_model->InsertRow('users',$args);
			        			if($insert_member){
			        				$this->session->set_flashdata('message_success', _l("User Inserted Successfully", $this));        				
			        			}
			        		}
                        }else{
                        	$this->session->set_flashdata('message_error', _l("Password not match", $this));                        	
                        }
        		}else{
        			$this->session->set_flashdata('message_error', _l("Password Atleast 6 Digit", $this));
        		}
        		redirect(base_url() . $lang . "/user", 'refresh');
        	}
        }
        
    	if(isset($_REQUEST['e_id'])){
    	if(GetPermission('is_edit')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        	$this->data['user_info'] = $this->NodCMS_general_model->QuerySingleRow('users',array('user_id'=>$_REQUEST['e_id']));
        }else{
        	$this->data['user_info'] = '';
        }
        
    	if(isset($_REQUEST['update_user'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		if($data['password']!=''){
        			if (strlen($data["password"]) >= 6) {
                        if (isset($data["confirm_password"]) && $data["confirm_password"] == $data["password"]) {
                        	
                        }else{
                        	$this->session->set_flashdata('message_error', _l("Password not match", $this));
                        	redirect(base_url() . $lang . "/user?e_id=".$data['user_id'], 'refresh');
                        }
        			}else{
        				$this->session->set_flashdata('message_error', _l("Password Atleast 6 Digit", $this));
        				redirect(base_url() . $lang . "/user?e_id=".$data['user_id'], 'refresh');
        			}
	        		$args = array(
	        			'username' 		=> $data['username'],
	        			'fullname' 		=> $data['username'],
		        		'email' 		=> $data['email'],
		        		'group_id' 	 	=> $data['group_id'],
		        		'password' 		=> md5($data['password']),
		        		'status' 		=> $data['status']
	        		);
        		}else{
        			$args = array(
	        			'username' 		=> $data['username'],
        				'fullname' 		=> $data['username'],
		        		'email' 		=> $data['email'],
		        		'group_id' 	 	=> $data['group_id'],
		        		'status' 		=> $data['status']
	        		);
        		}
        		
				$update_member = $this->NodCMS_general_model->UpdateRow('users',$args,array('user_id'=>$data['user_id']));
        		if($update_member){
        			$this->session->set_flashdata('message_success', _l("User Updated Successfully", $this));
        			}
        		redirect(base_url() . $lang . "/user?e_id=".$data['user_id'], 'refresh');
        	}
        }

        $this->data['user_groups'] = $this->NodCMS_general_model->QueryArray('groups');
        
        
        $this->data['title'] = _l('Add User', $this);
        $this->data['page_type'] = "users";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/user/user', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
	function BookingList($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $booking_list = $this->NodCMS_general_model->QueryArray('booking');
        $booking_data = array();
        if($booking_list){
        	foreach ($booking_list as $booking){
        		$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$booking['member_id']));
        		$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$booking['package_id']));
        		$payment_info = $this->NodCMS_general_model->QuerySingleRow('payment',array('booking_id'=>$booking['id']));
        		$booking_data[] = array('member_info'=>$member_info,'package_info'=>$package_info,'payment_info'=>$payment_info,'booking_info'=>$booking);
        	}
        }
        
        $this->data['booking_data'] = $booking_data;
        
        $this->data['title'] = _l('Booking', $this);
        $this->data['page_type'] = "booking-list";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/booking/booking_list', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Booking($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        
        $this->data['cpanel'] = $this->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        $this->data['members'] = $this->NodCMS_general_model->QueryArray("members",array("status"=>1));
        /*if(isset($_REQUEST['search'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		$this->data['member_list'] = $this->NodCMS_general_model->GetMembersBooking(array('member_number'=>$data['search_key']),array('member_name'=>$data['search_key']),array('member_email'=>$data['search_key']),array('contact_number'=>$data['search_key']));
        		$this->data['search_key'] = $data['search_key'];
        	}
        }else{
        	$this->data['member_list'] = '';
        	$this->data['search_key'] = '';
        }*/
        
       if(isset($_REQUEST['id'])){
        if(GetPermission('is_create')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        	$this->data['member_single'] = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$_REQUEST['id']));
        	$member_single = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$_REQUEST['id']));
        	$this->data['packages'] = $this->NodCMS_general_model->QueryArray("package",array("published"=>1));
        	$this->data['payments'] = $this->NodCMS_general_model->QueryArray("payment_type");
        	if($member_single->booking_id>0){
        		$this->data['payment_histories'] = $this->NodCMS_general_model->QueryArray("payment",array('booking_id'=>$member_single->booking_id));
        	}else{
        		$this->data['payment_histories'] =''; 
        	}
        	$this->data['trainees'] = $this->NodCMS_general_model->QueryArray("trainees",array('published'=>1));
        }else{
        	$this->data['member_single'] = '';
        	$this->data['packages'] = '';
        	$this->data['payments'] = '';
        	$this->data['payment_histories'] = '';
        	$this->data['trainees'] = '';
        }
        
    	if(isset($_REQUEST['e_id'])){
    		if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
    		$this->data['booking_data'] = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$_REQUEST['e_id']));
    		$booking_data = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$_REQUEST['e_id']));
        	$this->data['member_single'] = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$booking_data->member_id));
        	$this->data['packages'] = $this->NodCMS_general_model->QueryArray("package",array("published"=>1));
        	$this->data['payments'] = $this->NodCMS_general_model->QueryArray("payment_type");
        	$this->data['payment_histories'] = $this->NodCMS_general_model->QueryArray("payment",array('booking_id'=>$booking_data->id));
        	$this->data['trainees'] = $this->NodCMS_general_model->QueryArray("trainees",array('published'=>1));
        }else{
        	$this->data['booking_data'] = '';
        	
        }
        if (isset($_REQUEST['save_booking'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	$full_payment = (isset($data['full_payment'])) ? $data['full_payment'] : 0;
        	if($data){
				$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$data['package']));
				$update_reminder = $this->NodCMS_general_model->UpdateRow('payment',array('remember'=>0),array('member_id'=>$data['member_id'],'is_add_on'=>$package_info->add_on));
        		$booking_args = array(
        			'booking_number'=> GenerateBookingNo(),
        			'member_id'		=> $data['member_id'],
        			'package_id'	=> $data['package'],
        			'trainee_id'	=> $data['trainee'],
        			'nod'			=> $data['no_of_days'],
	        		'actual_amount'	=> $data['actual_amount'],
	        		'vat_amount'	=> $data['vat_amount'],
	        		'vat_percentage'=> $data['vat_percentage'],
	        		'amount'		=> $data['package_amount'],
        			'start_date'	=> date_to_DB(strtotime($data['start_date'])),
	        		'expire_date'	=> date_to_DB(strtotime($data['expire_date'])),
        			'remember'		=> $data['remember'],
        			'created_date'	=> date_to_DB(strtotime($data['booking_date'])).' '.CurrentTime(),
        			'status'		=> 1,
        			'user_id'		=> $_SESSION['user']['user_id']
        		);
        		
        		/*$count = $this->NodCMS_general_model->Count('booking',array('member_id'=>$data['member_id']));
        		if($count>0){
        			$this->session->set_flashdata('message_error', _l("Member Already Booked", $this));
        			redirect(base_url() . $lang . "/booking?id=".$data['member_id'], 'refresh');
        		}else{ */
        			$insert_booking = $this->NodCMS_general_model->InsertRow('booking',$booking_args);
        			if($insert_booking){
        				$last_booking_id = $this->NodCMS_general_model->InsertedID();
        				
        				$update_member = $this->NodCMS_general_model->UpdateRow('members',array('booking_id'=>$last_booking_id),array('id'=>$data['member_id']));
        				$this->session->set_flashdata('message_success', _l("Member Booked Successfully", $this));
        			}
        			redirect(base_url() . $lang . "/booking?e_id=".$last_booking_id, 'refresh');
        		/* }*/
        	}
        	
        }
        $this->data['trainees'] = $this->NodCMS_general_model->QueryArray("trainees",array('published'=>1));
        $this->data['packages'] = $this->NodCMS_general_model->QueryArray("package",array("published"=>1));
        
    if (isset($_REQUEST['update_booking'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	$full_payment = (isset($data['full_payment'])) ? $data['full_payment'] : 0;
        	if($data){
        		$booking_args = array(
        			'member_id'		=> $data['member_id'],
        			'package_id'	=> $data['package'],
        			'trainee_id'	=> $data['trainee'],
        			'nod'			=> $data['no_of_days'],
        			'actual_amount'	=> $data['actual_amount'],
	        		'vat_amount'	=> $data['vat_amount'],
	        		'vat_percentage'=> $data['vat_percentage'],
	        		'amount'		=> $data['package_amount'],
        			'start_date'	=> date_to_DB(strtotime($data['start_date'])),
	        		'expire_date'	=> date_to_DB(strtotime($data['expire_date'])),
        			'remember'		=> $data['remember'],
        			'created_date'	=> date_to_DB(strtotime($data['booking_date'])).' '.CurrentTime(),
        			'status'		=> 1,
        			'user_id'		=> $_SESSION['user']['user_id']
        		);
        		
        			$update_booking = $this->NodCMS_general_model->UpdateRow('booking',$booking_args,array('id'=>$data['booking_id']));
        			if($update_booking){
        				
        				$update_member = $this->NodCMS_general_model->UpdateRow('members',array('booking_id'=>$data['booking_id']),array('id'=>$data['member_id']));
        				$this->session->set_flashdata('message_success', _l("Member Updated Booked Successfully", $this));
        			}
        			redirect(base_url() . $lang . "/booking?e_id=".$data['booking_id'], 'refresh');
        	}
        	
        }

        $this->data['title'] = _l('New Booking', $this);
        $this->data['page_type'] = "booking-list";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/booking/booking', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Payments($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $payment_list = $this->NodCMS_general_model->QueryArray('payment',array('payment_status'=>1));
        $payment_data = array();
        if($payment_list){
        	foreach ($payment_list as $payment){
        		$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$payment['member_id']));
        		$booking_info = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$payment['booking_id']));
        		if($booking_info){
        			$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$booking_info->package_id));
        		}else{
        			$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$payment['package_id']));
        		}
        		$payment_type = $this->NodCMS_general_model->QuerySingleRow('payment_type',array('id'=>$payment['payment_type']));
        		
        		$payment_data[] = array('member_info'=>$member_info,'package_info'=>$package_info,'payment_info'=>$payment,'booking_info'=>$booking_info,'payment_type'=>$payment_type);
        	}
        }
        
        $this->data['payment_data'] = $payment_data;
        
        $this->data['title'] = _l('Payments', $this);
        $this->data['page_type'] = "payments";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/payment/payments', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Payment($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        
        $this->data['members'] = $this->NodCMS_general_model->GetMembers(array('member_number'=>''),array('member_name'=>''),array('member_email'=>''),array('contact_number'=>''));
        
        /*if(isset($_REQUEST['search'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		$this->data['member_list'] = $this->NodCMS_general_model->GetMembers(array('member_number'=>$data['search_key']),array('member_name'=>$data['search_key']),array('member_email'=>$data['search_key']),array('contact_number'=>$data['search_key']));
        		
        		$this->data['search_key'] = $data['search_key'];
        	}
        }else{
        	$this->data['member_list'] = '';
        	$this->data['search_key'] = '';
        }*/
        $this->data['error'] = '0';
        if(isset($_REQUEST['b_id'])){
        if(GetPermission('is_create')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        	$member_single = $this->NodCMS_general_model->QuerySingleRow('members',array('booking_id'=>$_REQUEST['b_id']));
        	if($member_single->booking_id!='0'){
	        	$this->data['member_single'] = $this->NodCMS_general_model->QuerySingleRow('members',array('booking_id'=>$_REQUEST['b_id']));
	        	$this->data['packages'] = $this->NodCMS_general_model->QueryArray("package",array("published"=>1));
	        	$this->data['payments'] = $this->NodCMS_general_model->QueryArray("payment_type");
	        	$this->data['payment_histories'] = $this->NodCMS_general_model->QueryArray("payment",array('booking_id'=>$member_single->booking_id));
	        	$this->data['trainees'] = $this->NodCMS_general_model->QueryArray("trainees",array('published'=>1));
	        }else{
	        	$this->data['member_single'] = '';
	        	$this->data['packages'] = '';
	        	$this->data['payments'] = '';
	        	$this->data['payment_histories'] = '';
	        	$this->data['trainees'] = '';
        		$this->data['error'] = '1';
        	}
        }else{
        	$this->data['member_single'] = '';
        	$this->data['packages'] = '';
        	$this->data['payments'] = '';
        	$this->data['payment_histories'] = '';
        	$this->data['trainees'] = '';
        }
        
        if(isset($_REQUEST['update_payment'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	
        	if($data){
        		
        		$booking_info = $this->NodCMS_general_model->QuerySingleRow("booking",array("id"=>$data['booking_id'],"member_id"=>$data['member_id']));        		
        		
        		$payment_query = $this->NodCMS_general_model->QueryArray("payment",array("booking_id"=>$data['booking_id'],"member_id"=>$data['member_id']));
        		//echo '<pre>';print_r($payment_query);die();
        		$payment_total = array();
        		if($payment_query){
        			foreach ($payment_query as $pay_total){
        				$payment_total[] = $pay_total['payment_amount'];
        			}
        			$total_payment = array_sum($payment_total);
        			
        			if($booking_info->amount<($total_payment+$data['amount'])){
        				$this->session->set_flashdata('message_error', _l("Payment Amount Exceed", $this));
        				redirect(base_url() . $lang . "/payment?e_id=".$data['booking_id'], 'refresh');
        			}else{
        				$update_args = array(
        					'payment_type' => $data['payment_mothod'],
			        		'payment_date' 	 => date_to_DB(strtotime($data['payment_date'])).' '.CurrentTime(),
			        		'payment_amount' => $data['amount']
        				);
        				$update_payment = $this->NodCMS_general_model->UpdateRow('payment',$update_args,array('id'=>$data['payment_id']));
        			}
        		}
        	}
        }
        
    	if(isset($_REQUEST['e_id'])){
    		if(GetPermission('is_create')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
    		$booking_data = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$_REQUEST['e_id']));
    		if(count($booking_data)>0){
	    		$this->data['booking_data'] = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$_REQUEST['e_id']));
	    		$this->data['member_single'] = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$booking_data->member_id));
	        	$this->data['package'] = $this->NodCMS_general_model->QuerySingleRow("package",array("id"=>$booking_data->package_id));
	        	$this->data['payments'] = $this->NodCMS_general_model->QueryArray("payment_type");
	        	$this->data['payment_histories'] = $this->NodCMS_general_model->QueryArray("payment",array('booking_id'=>$booking_data->id));
	        	$this->data['trainee'] = $this->NodCMS_general_model->QuerySingleRow("trainees",array('id'=>$booking_data->trainee_id));
	        	if(isset($_REQUEST['pid'])){
	        	if(GetPermission('is_view')==0){
		    		redirect(base_url() . $lang . "/access-denied", 'refresh');
		    	}
	        		$this->data['payment_edit'] = $this->NodCMS_general_model->QuerySingleRow("payment",array('id'=>$_REQUEST['pid']));
	        	}else{
	        		$this->data['payment_edit'] = '';
	        		
	        	}
    		}else{
    			$this->data['payment_edit'] = '';
    			$this->data['booking_data'] = '';
    			$this->data['error'] = '1';
    			$this->data['member_single'] = '';
	        		$this->data['package'] = '';
	        		$this->data['payments'] = '';
	        		$this->data['payment_histories'] = '';
	        		$this->data['trainee'] = '';
    		}
        }else{
        	$this->data['payment_edit'] = '';
        	$this->data['booking_data'] = '';
        	$this->data['member_single'] = '';
	        		$this->data['package'] = '';
	        		$this->data['payments'] = '';
	        		$this->data['payment_histories'] = '';
	        		$this->data['trainee'] = '';
        }
        
        if(isset($_REQUEST['save_payment'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		
        		$booking_info = $this->NodCMS_general_model->QuerySingleRow("booking",array("id"=>$data['booking_id'],"member_id"=>$data['member_id']));        		
        		
        		$payment_query = $this->NodCMS_general_model->QueryArray("payment",array("booking_id"=>$data['booking_id'],"member_id"=>$data['member_id']));
        		$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$data['package_id']));
        		//echo '<pre>';print_r($payment_query);die();
        		$payment_total = array();
        		if($payment_query){
        			foreach ($payment_query as $pay_total){
        				$payment_total[] = $pay_total['payment_amount'];
        			}
        			$total_payment = array_sum($payment_total);
        			
        			if($booking_info->amount<($total_payment+$data['amount'])){
        				$this->session->set_flashdata('message_error', _l("Payment Amount Exceed", $this));
        				redirect(base_url() . $lang . "/payment?e_id=".$data['booking_id'], 'refresh');
        			}else{
	        				
        				$args = array(
        						'payment_number'=> GenerateBookingPaymentNo(),
        						'booking_id'	=> $data['booking_id'],
        						'member_id'		=> $data['member_id'],
        						'package_id' 	=> $data['package_id'],
        						'is_add_on'		=> $package_info->add_on,
		        				'payment_type' 	=> $data['payment_mothod'],
					        	'payment_date' 	=> date_to_DB(strtotime($data['payment_date'])).' '.CurrentTime(),
					        	'payment_amount'=> $data['amount'],
					        	'payment_status'=> 1,
		        				'status'		=> 1,
        						'user_id'		=> $_SESSION['user']['user_id']
		        			);
		        			
        				$insert = $this->NodCMS_general_model->InsertRow("payment",$args);
        				$this->session->set_flashdata('message_success', _l("Payment Added Successfully.", $this));
        				redirect(base_url() . $lang . "/payment?e_id=".$data['booking_id'], 'refresh');
	        			
        			}
        		}else{
        			$args = array(
        						'payment_number'=> GenerateBookingPaymentNo(),
        						'booking_id'	=> $data['booking_id'],
        						'member_id'		=> $data['member_id'],
        						'package_id' 	=> $data['package_id'],
        						'is_add_on'		=> $package_info->add_on,
		        				'payment_type' 	=> $data['payment_mothod'],
					        	'payment_date' 	=> date_to_DB(strtotime($data['payment_date'])).' '.CurrentTime(),
					        	'payment_amount'=> $data['amount'],
					        	'payment_status'=> 1,
		        				'status'		=> 1,
        						'user_id'		=> $_SESSION['user']['user_id']
		        			);
		        			
        				$insert = $this->NodCMS_general_model->InsertRow("payment",$args);
        				$this->session->set_flashdata('message_success', _l("Payment Added Successfully.", $this));
        				redirect(base_url() . $lang . "/payment?e_id=".$data['booking_id'], 'refresh');
	        			
        		}
        	}
        }

        $this->data['title'] = _l('New Payment', $this);
        $this->data['page_type'] = "payments";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/payment/payment', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function DirectPayment($lang)
    {
        $this->preset($lang);
        
        if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        
    if(GetPermission('is_create')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
        $this->data['member_single'] = '';
        
        $this->data['packages'] = $this->NodCMS_general_model->QueryArray("package",array("published"=>1));
        $this->data['cpanel'] = $this->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        $this->data['members'] = $this->NodCMS_general_model->QueryArray("members",array("status"=>1));
        
        if(isset($_REQUEST['search'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		$this->data['member_list'] = $this->NodCMS_general_model->GetMembersBooking(array('member_number'=>$data['search_key']),array('member_name'=>$data['search_key']),array('member_email'=>$data['search_key']),array('contact_number'=>$data['search_key']));
        		
        		$this->data['search_key'] = $data['search_key'];
        	}
        }else{
        	$this->data['member_list'] = '';
        	$this->data['search_key'] = '';
        }
        $this->data['error'] = '0';
        
        
        if(isset($_REQUEST['update_payment'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$data['package']));
        		$update_args = array(
        			'package_id'	=> $data['package'],
        			'is_add_on'		=> $package_info->add_on,
        			'payment_type' 	=> $data['payment_mothod'],
			    	'payment_date' 	=> date_to_DB(strtotime($data['payment_date'])).' '.CurrentTime(),
			    	'no_of_members' => $data['no_of_members'],
        			'actual_amount' => $data['actual_amount'],
		        	'vat_amount' 	=> $data['vat_amount'],
		        	'vat_percentage'=> $data['vat_percentage'],
		        	'payment_amount'=> $data['package_amount'],
	        		'start_date' 	=> date_to_DB(strtotime($data['start_date'])),
	        		'expire_date' 	=> date_to_DB(strtotime($data['expire_date'])),
        			'remember'		=> $data['remember'],
        			'user_id'			=> $_SESSION['user']['user_id']
        		);
        		//P($update_args);
        		$update_payment = $this->NodCMS_general_model->UpdateRow('payment',$update_args,array('id'=>$data['payment_id']));
        		$this->session->set_flashdata('message_success', _l("Payment Updated Successfully.", $this));
        		redirect(base_url() . $lang . "/direct-payment?e_id=".$data['member_id'].'&p_id='.$data['payment_id'], 'refresh');
        	}
        }
        
    	if(isset($_REQUEST['e_id'])){
    		if(GetPermission('is_create')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
    			$this->data['member_single'] = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$_REQUEST['e_id']));
	        	$this->data['payments'] = $this->NodCMS_general_model->QueryArray("payment_type");
        }else{
        	$this->data['booking_data'] = '';
        $this->data['member_single'] = '';	
        }
    	
        if(isset($_REQUEST['p_id'])){
        	if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
    		$this->data['payment_info'] = $payment_info = $this->NodCMS_general_model->QuerySingleRow('payment',array('id'=>$_REQUEST['p_id']));
    		$this->data['package_info'] = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$payment_info->package_id));	        	
        }else{
        	$this->data['payment_info'] = '';
        	$this->data['package_info'] = '';
        }
        
        if(isset($_REQUEST['save_payment'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	if($data){
        		$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$data['package']));
						$update_reminder = $this->NodCMS_general_model->UpdateRow('payment',array('remember'=>0),array('member_id'=>$data['member_id'],'is_add_on'=>$package_info->add_on));
        				$args = array(
        						'payment_number'=> GeneratePaymentNo(),
        						'member_id'		=> $data['member_id'],
        						'package_id'	=> $data['package'],
        						'is_add_on'		=> $package_info->add_on,
		        				'payment_type' 	=> $data['payment_mothod'],
					        	'payment_date' 	=> date_to_DB(strtotime($data['payment_date'])).' '.CurrentTime(),
        						'no_of_members' => $data['no_of_members'],
        						'actual_amount' => $data['actual_amount'],
		        				'vat_amount' 	=> $data['vat_amount'],
		        				'vat_percentage'=> $data['vat_percentage'],
		        				'payment_amount'=> $data['package_amount'],
        						'start_date' 	=> date_to_DB(strtotime($data['start_date'])),
	        					'expire_date' 	=> date_to_DB(strtotime($data['expire_date'])),
        						'is_direct'		=> 1,
					        	'payment_status'=> 1,
        						'remember'		=> $data['remember'],
		        				'status'		=> 1,
        						'user_id'		=> $_SESSION['user']['user_id']
		        			);
		        			
        				$insert = $this->NodCMS_general_model->InsertRow("payment",$args);
        				$last = $this->NodCMS_general_model->InsertedID();
        				$this->session->set_flashdata('message_success', _l("Payment Added Successfully.", $this));
        				if(GetPermission('is_view')==1){
        					redirect(base_url() . $lang . "/direct-payment?e_id=".$data['member_id'].'&p_id='.$last, 'refresh');
        				}else{
        					redirect(base_url() . $lang . "/payments", 'refresh');
        				}
        	}
        }

        $this->data['title'] = _l('Direct Payment', $this);
        $this->data['page_type'] = "payments";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/payment/direct_payment', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function PrintPayment($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $data = ($_REQUEST) ? $_REQUEST : '';
        if($data){
        	$payment_details = $this->NodCMS_general_model->QuerySingleRow("payment",array('id'=>$data['id']));
        	if($payment_details->is_direct=='0'){
        		$booking_info = $this->NodCMS_general_model->QuerySingleRow("booking",array('id'=>$payment_details->booking_id));
	        	$this->data['booking_info'] = $booking_info;
	        	$this->data['member_info'] = $this->NodCMS_general_model->QuerySingleRow("members",array('id'=>$payment_details->member_id));
	        	$this->data['payment_type'] = $this->NodCMS_general_model->QuerySingleRow("payment",array('id'=>$payment_details->payment_type));
	        	$this->data['payment_info'] = $payment_details;
	        	
	        	$this->data['package_info'] = $this->NodCMS_general_model->QuerySingleRow("package",array('id'=>$booking_info->package_id));
        	}else{
        		$this->data['member_info'] = $this->NodCMS_general_model->QuerySingleRow("members",array('id'=>$payment_details->member_id));
	        	$this->data['payment_type'] = $this->NodCMS_general_model->QuerySingleRow("payment",array('id'=>$payment_details->payment_type));
	        	$this->data['payment_info'] = $payment_details;
	        	$this->data['package_info'] = $this->NodCMS_general_model->QuerySingleRow("package",array('id'=>$payment_details->package_id));
	        	$this->data['booking_info'] = '';
        	}
        	$this->data['cpanel_settings'] = $cpanel_settings = $this->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        	$this->data['company_info']= $this->NodCMS_general_model->QuerySingleRow('company',array('id'=>1));
	        $actual_amount = '';
	        $vat_amount = '';
	        $vat_enable = 'no';
	        $vat_percentage = '';
	        $amount = $payment_details->payment_amount;
	        if($cpanel_settings->vat==1){
	        	if($cpanel_settings->include_vat==1){
	        		$per_amount_in = ($amount*(100/(100+$cpanel_settings->vat_amount)));
	        		$actual_amount = $per_amount_in;
	        		$per_amount = ($per_amount_in*($cpanel_settings->vat_amount/100));
	        		$vat_amount = $per_amount;
	        		$amount = $per_amount+$per_amount_in;
	        	}else{
	        		$actual_amount = $amount;
	        		$per_amount = ($amount*($cpanel_settings->vat_amount/100));
	        		$vat_amount = $per_amount;
	        		$amount = $per_amount+$amount;
	        	}
	        	$vat_enable = 'yes';
	        	$vat_percentage = $cpanel_settings->vat_amount;
	        }
        }
        
        $this->data['title'] = _l('Invoice', $this);
        $this->data['page_type'] = "print-payment";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/print_payment', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function PrintBooking($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $data = ($_REQUEST) ? $_REQUEST : '';
        if($data){
        	$this->data['booking_info'] = $booking_details = $this->NodCMS_general_model->QuerySingleRow("booking",array('id'=>$data['id']));
        	$this->data['member_info'] = $this->NodCMS_general_model->QuerySingleRow("members",array('id'=>$booking_details->member_id));
        	$this->data['package_info'] = $this->NodCMS_general_model->QuerySingleRow("package",array('id'=>$booking_details->package_id));
        	$this->data['cpanel_settings'] = $cpanel_settings = $this->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        	$this->data['company_info']= $this->NodCMS_general_model->QuerySingleRow('company',array('id'=>1));
	        $actual_amount = '';
	        $vat_amount = '';
	        $vat_enable = 'no';
	        $vat_percentage = '';
	        $amount = $booking_details->actual_amount;
	        if($cpanel_settings->vat==1){
	        	if($cpanel_settings->include_vat==1){
	        		$per_amount_in = ($amount*(100/(100+$cpanel_settings->vat_amount)));
	        		$actual_amount = $per_amount_in;
	        		$per_amount = ($per_amount_in*($cpanel_settings->vat_amount/100));
	        		$vat_amount = $per_amount;
	        		$amount = $per_amount+$per_amount_in;
	        	}else{
	        		$actual_amount = $amount;
	        		$per_amount = ($amount*($cpanel_settings->vat_amount/100));
	        		$vat_amount = $per_amount;
	        		$amount = $per_amount+$amount;
	        	}
	        	$vat_enable = 'yes';
	        	$vat_percentage = $cpanel_settings->vat_amount;
	        }
        }
        
        $this->data['title'] = _l('Invoice', $this);
        $this->data['page_type'] = "print-payment";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/print_booking', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function AccessDenied($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        
        $this->data['title'] = _l('Users', $this);
        $this->data['page_type'] = "access-denied";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/denied', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Reports($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        
    	if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
    	$this->data['cpanel_setting'] = $this->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
    	$payment_list = $this->NodCMS_general_model->QueryArray('payment',array('DATE(payment_date)'=>date('Y-m-d'), 'payment_status'=>1));
		//echo $this->db->last_query();die();
        $payment_data = array();
        if($payment_list){
        	foreach ($payment_list as $payment){
        		$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$payment['member_id']));
        		$booking_info = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$payment['booking_id']));
        		if($booking_info){
        			$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$booking_info->package_id));
        		}else{
        			$package_info = '';
        		}
        		$payment_type = $this->NodCMS_general_model->QuerySingleRow('payment_type',array('id'=>$payment['payment_type']));
        	
        		$payment_data[] = array('member_info'=>$member_info,'package_info'=>$package_info,'payment_info'=>$payment,'booking_info'=>$booking_info,'payment_type'=>$payment_type);
        	}
        }
        $this->data['filter_data'] = '';
        if(isset($_REQUEST['filter_submit'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	$this->data['filter_data'] = $data;
        	if($data){
        		$member_list = '';
        		$package_list = '';
        		$where = array();
        		$where['payment_status'] = 1;
        		if($data['filter_name']!=''){
        			/*$member_ids = $this->NodCMS_general_model->FilterMember($data['filter_name']);
        			if($member_ids){
        				foreach($member_ids as $member_id){
        					$member_list[] = $member_id['id'];
        				}
        				$member_list = implode(",",$member_list);
        			}*/
        			$member_list = $data['filter_name'];
        		}
        		if($data['filter_date']!=''){
        			$dates = explode("-",$data['filter_date']);
        			$where['DATE(payment_date) >='] = date_to_DB(strtotime($dates[0]));
        			$where['DATE(payment_date) <='] = date_to_DB(strtotime($dates[1]));
        		}
        		if($data['filter_package']!=''){
        			/*$booking_ids = $this->NodCMS_general_model->QueryArray('booking',array('package_id'=>$data['filter_package']));
        			if($booking_ids){
        				foreach($booking_ids as $booking_id){
        					$package_list[] = $booking_id['id'];
        				}
        				$package_list = implode(",",$package_list);
        			}*/
        			$where['package_id'] = $data['filter_package'];
        		}
        		if($data['filter_pay_type']!=''){
        			$where['payment_type'] = $data['filter_pay_type'];
        		}
        	$payment_list = $this->NodCMS_general_model->QueryArrayInPayment('payment',$where,'member_id',$member_list,'booking_id',$package_list);
//echo $this->db->last_query();die();			
	        $payment_data = array();
	        if($payment_list){
	        	foreach ($payment_list as $payment){
	        		$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$payment['member_id']));
	        		$booking_info = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$payment['booking_id']));
	        		if($booking_info){
	        			$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$booking_info->package_id));
	        		}else{
	        			$package_info = '';
	        		}
	        		$payment_type = $this->NodCMS_general_model->QuerySingleRow('payment_type',array('id'=>$payment['payment_type']));
	        		$payment_data[] = array('member_info'=>$member_info,'package_info'=>$package_info,'payment_info'=>$payment,'booking_info'=>$booking_info,'payment_type'=>$payment_type);
	        	
	        	}
	        }
        	}
        }
        
        $this->data['payment_data'] = $payment_data;
		
        $this->data['packages'] = $this->NodCMS_general_model->QueryArray('package');
        $this->data['members'] = $this->NodCMS_general_model->QueryArray('members');
        $this->data['payment_types'] = $this->NodCMS_general_model->QueryArray('payment_type');
        		
        $this->data['title'] = _l('Payment Report', $this);
        $this->data['page_type'] = "reports";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/reports', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function PrintReport($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        
    if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
    	$this->data['cpanel_setting'] = $this->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
    	$payment_list = $this->NodCMS_general_model->QueryArray('payment',array('DATE(payment_date)'=>date('Y-m-d'), 'payment_status'=>1));
        $payment_data = array();
        if($payment_list){
        	foreach ($payment_list as $payment){
        		$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$payment['member_id']));
        		$booking_info = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$payment['booking_id']));
        		if($booking_info){
        			$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$booking_info->package_id));
        		}else{
        			$package_info = '';
        		}
        		$payment_type = $this->NodCMS_general_model->QuerySingleRow('payment_type',array('id'=>$payment['payment_type']));
        		$payment_data[] = array('member_info'=>$member_info,'package_info'=>$package_info,'payment_info'=>$payment,'booking_info'=>$booking_info,'payment_type'=>$payment_type);
        	}
        }
        $this->data['filter_data'] = '';
        if(isset($_REQUEST['filter_submit'])){
        	$data = ($_REQUEST) ? $_REQUEST : '';
        	$this->data['filter_data'] = $data;
        	if($data){
        		$member_list = '';
        		$package_list = '';
        		$where = array();
        		$where['payment_status'] = 1;
        		if($data['filter_name']!=''){
        			/*$member_ids = $this->NodCMS_general_model->FilterMember($data['filter_name']);
        			if($member_ids){
        				foreach($member_ids as $member_id){
        					$member_list[] = $member_id['id'];
        				}
        				$member_list = implode(",",$member_list);
        			}*/
        			$member_list = $data['filter_name'];
        		}
        		if($data['filter_date']!=''){
        			$dates = explode("-",$data['filter_date']);
        			$where['DATE(payment_date) >='] = date_to_DB(strtotime($dates[0]));
        			$where['DATE(payment_date) <='] = date_to_DB(strtotime($dates[1]));
        		}
        		if($data['filter_package']!=''){
        			/*$booking_ids = $this->NodCMS_general_model->QueryArray('booking',array('package_id'=>$data['filter_package']));
        			if($booking_ids){
        				foreach($booking_ids as $booking_id){
        					$package_list[] = $booking_id['id'];
        				}
        				$package_list = implode(",",$package_list);
        			}*/
        			$where['package_id'] = $data['filter_package'];
        		}
        		if($data['filter_pay_type']!=''){
        			$where['payment_type'] = $data['filter_pay_type'];
        		}
        	$payment_list = $this->NodCMS_general_model->QueryArrayInPayment('payment',$where,'member_id',$member_list,'booking_id',$package_list);
//echo $this->db->last_query();die();			
	        $payment_data = array();
	        if($payment_list){
	        	foreach ($payment_list as $payment){
	        		$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$payment['member_id']));
	        		$booking_info = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$payment['booking_id']));
	        		if($booking_info){
	        			$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$booking_info->package_id));
	        		}else{
	        			$package_info = '';
	        		}
	        		$payment_type = $this->NodCMS_general_model->QuerySingleRow('payment_type',array('id'=>$payment['payment_type']));
	        		$payment_data[] = array('member_info'=>$member_info,'package_info'=>$package_info,'payment_info'=>$payment,'booking_info'=>$booking_info,'payment_type'=>$payment_type);
	        	}
	        }
        	}
        }
        
        $this->data['payment_data'] = $payment_data;
		
        $this->data['packages'] = $this->NodCMS_general_model->QueryArray('package');
        $this->data['payment_types'] = $this->NodCMS_general_model->QueryArray('payment_type');
        $this->data['company_detail'] = $this->NodCMS_general_model->QuerySingleRow('company',array("id"=>1));
        $this->data['title'] = _l('Payment Report', $this);
        $this->data['page_type'] = "print-report";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/print_report', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Calendar($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        
    	if (isset($_REQUEST['action'])){
    		if($_REQUEST['action']=='load_event'){
    			$events = $this->NodCMS_general_model->QueryArray("calendar");
    			if($events){
    				foreach ($events as $event){
    					$data[] = array(
						  'id'   	=> $event["id"],
						  'title'   => $event["title"],
						  'start'   => $event["start_event"],
						  'end'   	=> $event["end_event"]
						 );
    				}
    				echo json_encode($data);
    				exit();
    			}
    		}
    		if($_REQUEST['action']=='insert'){
    			$data = ($_REQUEST) ? $_REQUEST : '';
    			if($data){
    				$args = array(
    						'title' 		=> $data['title'],
		    				'start_event' 	=> $data['start'],
		    				'end_event' 	=> $data['end']
		    			);
		    		$insert = $this->NodCMS_general_model->InsertRow("calendar",$args);
    			}
    		}
    		if($_REQUEST['action']=='update'){
    			$data = ($_REQUEST) ? $_REQUEST : '';
    			if($data){
    				$args = array(
    						'title' 		=> $data['title'],
		    				'start_event' 	=> $data['start'],
		    				'end_event' 	=> $data['end']
		    			);
		    		$update = $this->NodCMS_general_model->UpdateRow("calendar",$args,array('id'=>$data['id']));
    			}
    		}
    	if($_REQUEST['action']=='delete'){
    			$data = ($_REQUEST) ? $_REQUEST : '';
    			if($data){
    				$delete = $this->NodCMS_general_model->DeleteRow("calendar",array('id'=>$data['id']));
    			}
    		}
    	}
    	
    	$this->data['title'] = _l('Calendar', $this);
        $this->data['page_type'] = "calendar";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/calendar', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Notification($lang)
    {
        $this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
    if(GetPermission('is_create')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
		if(isset($_REQUEST['send_notification'])){
			if($_SESSION["user"]["group_id"]==1){
				$data = ($_REQUEST) ? $_REQUEST : '';
				//echo '<pre>'.print_r($data).'</pre>';die();
				if($data){
					$param = array(
					'username' => 'qbmsoft',	
					'password' => 'qbm987',
					'senderid' => 'SMS Alert',
					'text' => $data['message'],
					'type' => 'text',
					'datetime' => date("Y-m-d G:i:s"),
				);
				$post = 'to=' . $data['mobile_number'];
				foreach ($param as $key => $val) {
					$post .= '&' . $key . '=' . rawurlencode($val);
				}
				$url = "https://www.smartsmsgateway.com/api/api_json.php";
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $url);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_TIMEOUT, 30);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
				curl_setopt($ch, CURLOPT_HTTPHEADER, array("Connection: close"));
				$result = curl_exec($ch);
				$status = 0;
				if(curl_errno($ch)) {
					$result = "cURL ERROR: " . curl_errno($ch) . " " . curl_error($ch);
					$status = 1;
				} else {
					$returnCode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
					switch($returnCode) {
						case 200 :
							break;
						default :
							$result = "HTTP ERROR: " . $returnCode;
							$status = 1;
					}
				}
				curl_close($ch);
				//print $result;
				$args = array(
					'mobile_number' => $data['mobile_number'],
					'message'   	=> $data['message'],
					'result'   		=> $result,
					'created_date' 	=> strtotime(date("Y-m-d")),
					'status'		=> $status
					);
				$insert = $this->NodCMS_general_model->InsertRow("notifications",$args);
				}
			}else{
				$this->session->set_flashdata('message_error', _l("User permission Denied ", $this));
				redirect(base_url() . $lang . "/notification", 'refresh');
			}
        }

        $this->data['notifications'] = $this->NodCMS_general_model->QueryLimit("notifications",'',10,'id','DESC');
        
        $this->data['title'] = _l('Notification', $this);
        $this->data['page_type'] = "notification";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/notification', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Cpanel($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
	    
    	if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    	
	    $this->data['languages']	= $this->NodCMS_general_model->QueryArray("languages");
	    $this->data['currencies']	= $this->NodCMS_general_model->QueryArray("currency");
	    $this->data['currency_sub']	= $this->NodCMS_general_model->QueryArray("currency_sub");
	    $this->data['cpanel_info']	= $this->NodCMS_general_model->QuerySingleRow("cpanel",array("id"=>1));
	    
	    if(isset($_REQUEST['update_cpanel'])){
	    	$data = ($_REQUEST) ? $_REQUEST : '';
	    	//print_r($data['sms']);die();
	    	if($data){
	    		$args = array(
	    				'vat'			=> $data['vat'],
			    		'vat_code'		=> $data['vat_code'],
			    		'vat_amount'	=> $data['vat_amount'],
			    		'main_currency'	=> $data['main_currency'],
			    		'sub_currency'	=> $data['sub_currency'],
			    		'decimal_place'	=> $data['decimal_place'],
			    		'member_prefix'	=> $data['member_prefix'],
			    		'trainee_prefix'=> $data['trainee_prefix'],
			    		'employee_prefix'=> $data['employee_prefix'],
			    		'payment_prefix'=> $data['payment_prefix'],
			    		'booking_prefix'=> $data['booking_prefix'],
			    		'booking_payment_prefix'=> $data['booking_payment_prefix'],
	    				'password_type'	=> $data['password_type'],
	    				'include_vat'	=> $data['include_vat']
	    			);
	    			
	    		$update_sms_to_zero = $this->NodCMS_general_model->UpdateRow('smscategory',array('status'=>0),array());
	    		if(count($data['sms'])>0){
	    			foreach ($data['sms'] as $sms){
	    				$update_sms = $this->NodCMS_general_model->UpdateRow('smscategory',array('status'=>$sms['status']),array('id'=>$sms['id']));
	    			}
	    		}
	    		
	    		$update = $this->NodCMS_general_model->UpdateRow('cpanel',$args,array('id'=>1));
	    		if($update){
        			$this->session->set_flashdata('message_success', _l("Details Updated Successfully", $this));
        		}
	    	}
	    	redirect(base_url() . $lang . "/cpanel", 'refresh');
	    }
	    
	    /*SAVE MEMBER MESSAGE*/
	    if(isset($_REQUEST['save_member_message'])){
	    	$args = array('message'=>$_REQUEST['member_message'],'category'=>1);
	    	$count = $this->NodCMS_general_model->Count('smstemplates',$args);
	    	if($count>0){
        		$this->session->set_flashdata('message_error', _l("Message Already Saved", $this));
        	}else{
        		$insert = $this->NodCMS_general_model->InsertRow('smstemplates',$args);
        		if($insert){
        			$this->session->set_flashdata('message_success', _l("Message Saved Successfully.", $this));
        		}
        	}
        	redirect(base_url() . $lang . "/cpanel", 'refresh');
	    }
	    
    	/*SAVE TRAINEE MESSAGE*/
	    if(isset($_REQUEST['save_trainee_message'])){
	    	$args = array('message'=>$_REQUEST['trainee_message'],'category'=>2);
	    	$count = $this->NodCMS_general_model->Count('smstemplates',$args);
	    	if($count>0){
        		$this->session->set_flashdata('message_error', _l("Message Already Saved", $this));
        	}else{
        		$insert = $this->NodCMS_general_model->InsertRow('smstemplates',$args);
        		if($insert){
        			$this->session->set_flashdata('message_success', _l("Message Saved Successfully.", $this));
        		}
        	}
        	redirect(base_url() . $lang . "/cpanel", 'refresh');
	    }
	    
    	/*SAVE BOOKING MESSAGE*/
	    if(isset($_REQUEST['save_booking_message'])){
	    	$args = array('message'=>$_REQUEST['booking_message'],'category'=>3);
	    	$count = $this->NodCMS_general_model->Count('smstemplates',$args);
	    	if($count>0){
        		$this->session->set_flashdata('message_error', _l("Message Already Saved", $this));
        	}else{
        		$insert = $this->NodCMS_general_model->InsertRow('smstemplates',$args);
        		if($insert){
        			$this->session->set_flashdata('message_success', _l("Message Saved Successfully.", $this));
        		}
        	}
        	redirect(base_url() . $lang . "/cpanel", 'refresh');
	    }
	    
	    $this->data['sms_templates'] = $this->NodCMS_general_model->QueryArray("smstemplates");
	    $this->data['sms_categories'] = $this->NodCMS_general_model->QueryArray("smscategory");
	    
	    $this->data['title'] = _l('Control Panel', $this);
        $this->data['page_type'] = "cpanel";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/cpanel', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
    
	function CompanyProfile($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
	    
    if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    	
	    if(isset($_REQUEST['save_company'])){
	    if(GetPermission('is_edit')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    	$data = ($_REQUEST) ? $_REQUEST : '';
	    	if($data){
	    		$target_dir = "upload/";
				$target_file = $target_dir . basename($_FILES["logo"]["name"]);
				$uploadOk = 1;
				$imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
				if(basename($_FILES["logo"]["name"])){
			    	if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif" ) {
					    $this->session->set_flashdata('message_error', _l("Sorry, only JPG, JPEG, PNG & GIF files are allowed.", $this));
					    redirect(base_url() . $lang . "/company", 'refresh');
					    $uploadOk = 0;
					}
					
			    	if ($uploadOk == 0) {
					    $this->session->set_flashdata('message_error', _l("Sorry, your file was not uploaded.", $this));
						redirect(base_url() . $lang . "/company", 'refresh');
					} else {
					    if (move_uploaded_file($_FILES["logo"]["tmp_name"], $target_file)) {
					       // echo "The file ". basename( $_FILES["logo"]["name"]). " has been uploaded.";
					    } else {
					       // echo "Sorry, there was an error uploading your file.";
					    }
					}
					$logo = $target_file;
				}else{
					$logo = $data['image_path'];
				}
			
					
	    		
	    		$args = array(
	    				'company_name' 		=> $data['company_name'],
	    				'address_1'			=> $data['address_1'],
	    				'address_2'			=> $data['address_2'],
	    				'address_3'			=> $data['address_3'],
						'address_4'			=> $data['address_4'],
	    				'address_5'			=> $data['address_5'],
			    		'logo'				=> $logo,
			    		'document_name'		=> $data['document_name'],
			    		'document_number'	=> $data['document_number'],
			    		'issue_date'		=> date_to_DB(strtotime($data['issue_date'])),
			    		'expire_date'		=> date_to_DB(strtotime($data['expire_date']))
	    			);
	    		$update = $this->NodCMS_general_model->UpdateRow('company',$args,array('id'=>1));
	    		if($update){
        			$this->session->set_flashdata('message_success', _l("Company Profile Updated Successfully", $this));
        		}
	    	}
	    	redirect(base_url() . $lang . "/company", 'refresh');
	    }
	    
	    $this->data['company_info'] = $this->NodCMS_general_model->QuerySingleRow('company',array('id'=>1));
	    
	    $this->data['title'] = _l('Company Profile', $this);
        $this->data['page_type'] = "company";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/company_profile', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Package($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    if(GetPermission('is_create')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    if(isset($_REQUEST['save_package'])){
	    	$data = ($_REQUEST) ? $_REQUEST : '';
	    	if($data){
	    		$args = array(
	    				'package_name'	=> $data['package_name'],
	    				'nod'			=> $data['nod'],
	    				'package_type'	=> $data['package_type'],
	    				'Amount'		=> $data['amount'],
	    				'add_on'		=> $data['add_on'],
	    				'published'		=> $data['published'],
	    				'created_date'	=> date('Y-m-d'),
	    				'user_id'		=> $_SESSION['user']['user_id']
	    				);
	    		$check = $this->NodCMS_general_model->Count('package',array('package_name'=>$data['package_name']));
	    		if($check==0){
	    			$insert = $this->NodCMS_general_model->InsertRow('package',$args);
	    			$this->session->set_flashdata('message_success', _l("Package Saved Successfully", $this));
	    		}else{
	    			$this->session->set_flashdata('message_danger', _l("Package name already Exist.", $this));
	    		}
	    		redirect(base_url() . $lang . "/package", 'refresh');
	    	}
	    }
	    
	    if(isset($_REQUEST['update_package'])){
	    	$data = ($_REQUEST) ? $_REQUEST : '';
	    	if($data){
	    		$args = array(
	    				'package_name'	=> $data['package_name'],
	    				'nod'			=> $data['nod'],
	    				'package_type'	=> $data['package_type'],
	    				'Amount'		=> $data['amount'],
	    				'add_on'		=> $data['add_on'],
	    				'published'		=> $data['published'],
	    				'user_id'		=> $_SESSION['user']['user_id']
	    				);
	    		//$check = $this->NodCMS_general_model->Count('package',array('package_name'=>$data['package_name']));
	    		//if($check==0){
	    			$insert = $this->NodCMS_general_model->UpdateRow('package',$args,array('id'=>$data['package_id']));
	    			$this->session->set_flashdata('message_success', _l("Package Updated Successfully", $this));
	    			redirect(base_url() . $lang . "/package?e_id=".$data['package_id'], 'refresh');
	    		/*}else{
	    			$this->session->set_flashdata('message_danger', _l("Package name already Exist.", $this));
	    		}*/
	    	}
	    }
	    
   		 if(isset($_REQUEST['e_id'])){
   		 if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    	$this->data['package'] = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$_REQUEST['e_id']));
	    }else{
	    	$this->data['package'] = '';
	    }
	    
	    
	    $this->data['title'] = _l('Packages', $this);
        $this->data['page_type'] = "package";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/package', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Packages($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    	
	    if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}	    
	    
	    $this->data['packages'] = $this->NodCMS_general_model->QueryArray('package');
    	if(isset($_REQUEST['filter_status']) && ($_REQUEST['filter_status']!='*')){
    		$this->data['packages'] = $this->NodCMS_general_model->QueryArray('package',array("published"=>$_REQUEST['filter_status']));
	    }
	    $this->data['title'] = _l('Packages', $this);
        $this->data['page_type'] = "package";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/packages', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Expense($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
	    
    if(GetPermission('is_create')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    if(isset($_REQUEST['save_expense'])){
	    	$data = ($_REQUEST) ? $_REQUEST : '';
	    	if($data){
	    		$args = array(
	    				'expense_name'	=> $data['expense_name'],
	    				'type'			=> $data['type'],
	    				'expense_date'	=> date_to_DB(strtotime($data['expense_date'])),
			    		'amount'		=> $data['amount'],
			    		'notes'			=> $data['notes'],
	    				'created_date'	=> date('Y-m-d'),
	    				'user_id'		=> $_SESSION['user']['user_id']
	    				);
    			$insert = $this->NodCMS_general_model->InsertRow('expense',$args);
    			$this->session->set_flashdata('message_success', _l("Expense Saved Successfully", $this));
    		
	    		redirect(base_url() . $lang . "/expense", 'refresh');
	    	}
	    }
	    
	    if(isset($_REQUEST['update_expense'])){
	    	$data = ($_REQUEST) ? $_REQUEST : '';
	    	if($data){
	    		$args = array(
	    				'expense_name'	=> $data['expense_name'],
	    				'type'			=> $data['type'],
	    				'expense_date'	=> date_to_DB(strtotime($data['expense_date'])),
			    		'amount'		=> $data['amount'],
			    		'notes'			=> $data['notes'],
	    				'created_date'	=> date('Y-m-d'),
	    				'user_id'		=> $_SESSION['user']['user_id']
	    				);
	    		//$check = $this->NodCMS_general_model->Count('package',array('package_name'=>$data['package_name']));
	    		//if($check==0){
	    			$insert = $this->NodCMS_general_model->UpdateRow('expense',$args,array('id'=>$data['expense_id']));
	    			$this->session->set_flashdata('message_success', _l("Expense Updated Successfully", $this));
	    			redirect(base_url() . $lang . "/expense?e_id=".$data['expense_id'], 'refresh');
	    		/*}else{
	    			$this->session->set_flashdata('message_danger', _l("Package name already Exist.", $this));
	    		}*/
	    	}
	    }
	    
   		 if(isset($_REQUEST['e_id'])){
   		 if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    	$this->data['expense'] = $this->NodCMS_general_model->QuerySingleRow('expense',array('id'=>$_REQUEST['e_id']));
	    }else{
	    	$this->data['expense'] = '';
	    }
	    
	    
	    $this->data['title'] = _l('Expense', $this);
        $this->data['page_type'] = "expense";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/expense', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Expenses($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
	    
    if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    	
	    $this->data['expense_list'] = $this->NodCMS_general_model->QueryArray('expense');
	    
	    $this->data['title'] = _l('Expenses', $this);
        $this->data['page_type'] = "expense";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/expenses', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function PaymentReport($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
	    
    	if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    	$this->data['filter_member'] = '';
	    $this->data['filter_package'] = '';
	    $where = array("status"=>1);
	    if(isset($_REQUEST['filter_submit'])){
	    	$data= ($_REQUEST) ? $_REQUEST : '';
	    	if($data['filter_member']){
	    		$this->data['filter_member'] = $where['member_id'] = $data['filter_member'];
	    	}
	    	if($data['filter_package']){
	    		$this->data['filter_package'] = $where['package_id'] = $data['filter_package'];
	    	}
	    }	
	    	$events = array();
    	$pending_payments = $this->NodCMS_general_model->QueryArray("booking",$where);
		if($pending_payments){
			foreach ($pending_payments as $pending_payment){
				$payment_info = $this->NodCMS_general_model->GetPendingPayment(array("booking_id"=>$pending_payment['id'],"member_id"=>$pending_payment['member_id'],'package_id'=>$pending_payment['package_id']));
				if($payment_info){
					if($payment_info->total != $pending_payment['amount']){
						$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$pending_payment['member_id']));
						$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$pending_payment['package_id']));
						$events[] = array("booking_info"=>$pending_payment,"payment_info"=>$payment_info,"member_info"=>$member_info,"package_info"=>$package_info);
					}
				}
			}
		}
		$this->data['member_list'] = $this->NodCMS_general_model->QueryArrayGroup('booking',array("status"=>1),'member_id');
		$this->data['package_lists'] = $this->NodCMS_general_model->QueryArray('package');
	    $this->data['payment_lists'] = $events;
		
	    $this->data['title'] = _l('Pending Payments', $this);
        $this->data['page_type'] = "pending-payments";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/pending_payments', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function PackageReport($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
	    
    	if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    $where = array("");
	    $this->data['filter_member'] = '';
	    $this->data['filter_package'] = '';
	    $this->data['filter_status'] = '';
	    $filter_status = '';
	    if(isset($_REQUEST['filter_submit'])){
	    	$data= ($_REQUEST) ? $_REQUEST : '';
	    	if($data['filter_member']){
	    		$this->data['filter_member'] = $where['member_id'] = $data['filter_member'];
	    		
	    	}
	    	if($data['filter_package']){
	    		$this->data['filter_package'] = $where['package_id'] = $data['filter_package'];
	    	}
	    	if($data['filter_status']){
	    		$this->data['filter_status'] = $filter_status = $data['filter_status'];
	    	}
	    }	
	    	$events = array();
    
	    $expire_payments = $this->NodCMS_general_model->GetExpirePaymentReport($where,$filter_status);
		if($expire_payments){
			foreach ($expire_payments as $expire_payment){
				$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$expire_payment['member_id']));
				$now = time(); // or your date as well
				$your_date = strtotime($expire_payment['expire_date']);
				$datediff = $your_date - $now;
				
				$no_days = round($datediff / (60 * 60 * 24));
				
						//$events[] = array('title'=>$member_info->member_name,'descrption'=>$description,'date'=>$expire_payment['expire_date'],'type'=>'payment');
						$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$expire_payment['package_id']));
						$booking_info = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$expire_payment['booking_id']));
						if($package_info->package_type==1){
							$events[] = array("booking_info"=>$booking_info,"payment_info"=>$expire_payment,"member_info"=>$member_info,"package_info"=>$package_info);
						}
				  
			}
		}
		
		$this->data['member_list'] = $this->NodCMS_general_model->QueryArray('members');
		$this->data['package_lists'] = $this->NodCMS_general_model->QueryArray('package');
	    $this->data['package_lists_report'] = $events;
		
	    $this->data['title'] = _l('Package Expire List', $this);
        $this->data['page_type'] = "expire-package";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/expire_package', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
    
	function PrintExpirePackage($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
	    
    	if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    $where = array("");
	    $this->data['filter_member'] = '';
	    $this->data['filter_package'] = '';
	    $this->data['filter_status'] = '';
	    $filter_status = '';
	    if(isset($_REQUEST['filter_submit'])){
	    	$data= ($_REQUEST) ? $_REQUEST : '';
	    	if($data['filter_member']){
	    		$this->data['filter_member'] = $where['member_id'] = $data['filter_member'];
	    		
	    	}
	    	if($data['filter_package']){
	    		$this->data['filter_package'] = $where['package_id'] = $data['filter_package'];
	    	}
	    	if($data['filter_status']){
	    		$this->data['filter_status'] = $filter_status = $data['filter_status'];
	    	}
	    }	
	    	$events = array();
    
	    $expire_payments = $this->NodCMS_general_model->GetExpirePaymentReport($where,$filter_status);
		if($expire_payments){
			foreach ($expire_payments as $expire_payment){
				$member_info = $this->NodCMS_general_model->QuerySingleRow('members',array('id'=>$expire_payment['member_id']));
				$now = time(); // or your date as well
				$your_date = strtotime($expire_payment['expire_date']);
				$datediff = $your_date - $now;
				
				$no_days = round($datediff / (60 * 60 * 24));
				
						//$events[] = array('title'=>$member_info->member_name,'descrption'=>$description,'date'=>$expire_payment['expire_date'],'type'=>'payment');
						$package_info = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$expire_payment['package_id']));
						$booking_info = $this->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$expire_payment['booking_id']));
						if($package_info->package_type==1){
							$events[] = array("booking_info"=>$booking_info,"payment_info"=>$expire_payment,"member_info"=>$member_info,"package_info"=>$package_info);
						}
				  
			}
		}
		
		$this->data['company_detail'] = $this->NodCMS_general_model->QuerySingleRow('company',array("id"=>1));
		$this->data['member_list'] = $this->NodCMS_general_model->QueryArray('members');
		$this->data['package_lists'] = $this->NodCMS_general_model->QueryArray('package');
	    $this->data['package_lists_report'] = $events;
		
	    $this->data['title'] = _l('Package Expire List', $this);
        $this->data['page_type'] = "print-report";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/print_expire_package', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function Inquiry($lang)
    {
        $this->preset($lang);
	    if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    	if(GetPermission('is_create')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    if(isset($_REQUEST['save_inquiry'])){
	    	$data = ($_REQUEST) ? $_REQUEST : '';
	    	if($data){
	    		$args = array(
	    				'name'			=> $data['name'],
	    				'i_date'		=> date_to_DB(strtotime($data['i_date'])),
	    				'description'	=> $data['description'],
	    				'date_follow'	=> date_to_DB(strtotime($data['date_follow'])),
	    				'contact_number'=> $data['contact_number'],
	    				'remarks'		=> $data['remarks'],
	    				'status'		=> $data['status'],
	    				'user_id'		=> $_SESSION['user']['user_id']
	    				);
	    			//echo '<pre>'.print_r($args).'</pre>';die();	
    			$insert = $this->NodCMS_general_model->InsertRow('inquiry',$args);
    			$this->session->set_flashdata('message_success', _l("Inquiry Saved Successfully", $this));
	    		
	    		redirect(base_url() . $lang . "/inquiry", 'refresh');
	    	}
	    }
	    
	    if(isset($_REQUEST['update_inquiry'])){
	    	$data = ($_REQUEST) ? $_REQUEST : '';
	    	if($data){
	    		$args = array(
	    				'name'			=> $data['name'],
	    				'i_date'		=> date_to_DB(strtotime($data['i_date'])),
	    				'description'	=> $data['description'],
	    				'date_follow'	=> date_to_DB(strtotime($data['date_follow'])),
	    				'contact_number'=> $data['contact_number'],
	    				'remarks'		=> $data['remarks'],
	    				'status'		=> $data['status'],
	    				'user_id'		=> $_SESSION['user']['user_id']
	    				);
	    				//echo '<pre>'.print_r($args).'</pre>';die();
	    		
    			$insert = $this->NodCMS_general_model->UpdateRow('inquiry',$args,array('id'=>$data['inquiry_id']));
    			$this->session->set_flashdata('message_success', _l("Inquiry Updated Successfully", $this));
    			redirect(base_url() . $lang . "/inquiry?e_id=".$data['inquiry_id'], 'refresh');
	    		
	    	}
	    }
	    
   		 if(isset($_REQUEST['e_id'])){
   		 if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
	    	$this->data['inquiry'] = $this->NodCMS_general_model->QuerySingleRow('inquiry',array('id'=>$_REQUEST['e_id']));
	    }else{
	    	$this->data['inquiry'] = '';
	    }
	    
	    
	    $this->data['inquiries'] = $this->NodCMS_general_model->QueryArray('inquiry');
	    
	    $this->data['title'] = _l('Add Inquiry', $this);
        $this->data['page_type'] = "inquiry";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/inquiry', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
    function Inquiries($lang){
    	$this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
    	if(GetPermission('is_view')==0){
	    		redirect(base_url() . $lang . "/access-denied", 'refresh');
	    	}
    	$this->data['inquiries'] = $this->NodCMS_general_model->QueryArray('inquiry');
	    
	    $this->data['title'] = _l('Inquiries', $this);
        $this->data['page_type'] = "inquiry";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/inquiries', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');
    }
    
	function StateList($lang)
    {
        $this->preset($lang);
        $state_list = $this->NodCMS_general_model->QueryArray('states',array('country_id'=>$_REQUEST['country_id']),'name','ASC');
        echo json_encode($state_list);
    }
    
	function Ajax($lang)
    {
        $this->preset($lang);
        if($_REQUEST['page_type']=='package'){
	        $details = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$_REQUEST['package_id']));
	        if($details->nod!=0){
	        	//$date = new DateTime('+'.($details->nod-1).' day');
	        	$date = date('d-m-Y', strtotime(' + '.($details->nod-1) .' days'));
	        }else{
	        	//$date = new DateTime('+'.($details->nod).' day');
	        	$date = date('d-m-Y', strtotime(' + '.($details->nod-1) .' days'));
	        }
	        $amount = $details->amount;
	        $cpanel_settings = $this->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
	        $actual_amount = '';
	        $vat_amount = '';
	        $vat_enable = 'no';
	        $vat_percentage = '';
	        if($cpanel_settings->vat==1){
	        	if($cpanel_settings->include_vat==1){
	        		$per_amount_in = ($amount*(100/(100+$cpanel_settings->vat_amount)));
	        		$actual_amount = $per_amount_in;
	        		$per_amount = ($per_amount_in*($cpanel_settings->vat_amount/100));
	        		$vat_amount = $per_amount;
	        		$amount = $per_amount+$per_amount_in;
	        	}else{
	        		$actual_amount = $amount;
	        		$per_amount = ($amount*($cpanel_settings->vat_amount/100));
	        		$vat_amount = $per_amount;
	        		$amount = $per_amount+$amount;
	        	}
	        	$vat_enable = 'yes';
	        	$vat_percentage = $cpanel_settings->vat_amount;
	        }
	        
		    $package_details = array(
		    			'nod'=>$details->nod,
		    			'package_type'=>$details->package_type,
		    			'amount'=>$amount,
		    			'amount_d'=>PriceFormat($amount),
		    			'actual_amount'=>$actual_amount,
		    			'actual_amount_d'=>PriceFormat($actual_amount),
		    			'vat_amount'=>$vat_amount,
		    			'vat_amount_d'=>PriceFormat($vat_amount),
		    			'vat_percentage'=>$vat_percentage,
		    			'vat_enable'=>$vat_enable,
		    			'expire_date'=>$date
		    		);
	        echo json_encode($package_details);
        }
        
    if($_REQUEST['page_type']=='package_member'){
    		$no_of_customers = $_REQUEST['no_of_customers']; 
	        $details = $this->NodCMS_general_model->QuerySingleRow('package',array('id'=>$_REQUEST['package_id']));
    		if($details->nod!=0){
	        	$date = date('d-m-Y', strtotime(' + '.$details->nod .' days'));
	        }else{
	        	$date = date('d-m-Y', strtotime(' + '.$details->nod .' days'));
	        }
	        $amount = $details->amount*$no_of_customers;
	        $cpanel_settings = $this->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
	        $actual_amount = '';
	        $vat_amount = '';
	        $vat_enable = 'no';
	        $vat_percentage = '';
	        if($cpanel_settings->vat==1){
	        	if($cpanel_settings->include_vat==1){
	        		$per_amount_in = ($amount*(100/(100+$cpanel_settings->vat_amount)));
	        		$actual_amount = $per_amount_in;
	        		$per_amount = ($per_amount_in*($cpanel_settings->vat_amount/100));
	        		$vat_amount = $per_amount;
	        		$amount = $per_amount+$per_amount_in;
	        	}else{
	        		$actual_amount = $amount;
	        		$per_amount = ($amount*($cpanel_settings->vat_amount/100));
	        		$vat_amount = $per_amount;
	        		$amount = $per_amount+$amount;
	        	}
	        	$vat_enable = 'yes';
	        	$vat_percentage = $cpanel_settings->vat_amount;
	        }
	        
		    $package_details = array(
		    			'nod'=>$details->nod,
		    			'amount'=>$amount,
		    			'amount_d'=>PriceFormat($amount),
		    			'actual_amount'=>$actual_amount,
		    			'actual_amount_d'=>PriceFormat($actual_amount),
		    			'vat_amount'=>$vat_amount,
		    			'vat_amount_d'=>PriceFormat($vat_amount),
		    			'vat_percentage'=>$vat_percentage,
		    			'vat_enable'=>$vat_enable,
		    			'expire_date'=>$date
		    		);
	        echo json_encode($package_details);
        }
        
    
        if($_REQUEST['page_type']=='payment_info'){
        	$payment_detail = $this->NodCMS_general_model->QuerySingleRow('payment',array('id'=>$_REQUEST['payment_id']));
        	$payment = array("payment_id"=>$payment_detail->id,'payment_number'=>$payment_detail->payment_number,'payment_amount'=>$payment_detail->installment_amount,'payment_date'=>date_to_Display(strtotime($payment_detail->installment_date)));
        	echo json_encode($payment);
        }
        
    	if($_REQUEST['page_type']=='payment_info_update'){
        	$update = $this->NodCMS_general_model->UpdateRow('payment',array('installment_amount'=>$_REQUEST['payment_amount'],'installment_date'=>date_to_DB(strtotime($_REQUEST['payment_date']))) ,array('id'=>$_REQUEST['payment_id']));
        	$payment = array("status"=>"success",'message'=>"Payment Updated Successfully");
        	echo json_encode($payment);
        }
        
    	if($_REQUEST['page_type']=='booking_installment'){
	        $html = '<div class="table-responsive">
                		<table class="table">
                			<tr>
                				<th>'._l("No",$this).'</th>
                				<th>'._l("Amount",$this).'</th>
                				<th>'._l("Date",$this).'</th>
                				<th>'._l("Status",$this).'</th>
                				<th>'._l("SMS",$this).'</th>
                			</tr>';
	        		if($_REQUEST['key_value']>0){
	        			for ($i=0;$i<$_REQUEST['key_value'];$i++){
	        				$payment_number = GeneratePaymentNo($i+1);
		                	$html .= '<tr>
		                				<td>'.$payment_number.'<input type="hidden" name="inst['.$i.'][payment_number]" class="form-control" value="'.$payment_number.'"></td>
		                				<td><input type="text" name="inst['.$i.'][amount]" class="validate[required,custom[number]] form-control valiidate_total" value=""></td>
		                				<td><input type="text" name="inst['.$i.'][date]" class="form-control datepicker" value="'.date('d-m-Y').'">
		                				<input type="hidden" name="inst['.$i.'][status]" value="0">
		                				</td>
		                				<td>'.PaymentStatus(0).'</td>
		                				<td><input class="btn btn-success" type="button" value="'._l("SMS",$this).'"></td>
		                			</tr>';
			        			}
			        		}
                	$html .= '</table>
                	</div>';
	        echo $html;
        }
        
    if($_REQUEST['page_type']=='full_payment'){
	        $html = '<div class="table-responsive">
                		<table class="table">
                			<tr>
                				<th>'._l("No",$this).'</th>
                				<th>'._l("Amount",$this).'</th>
                				<th>'._l("Date",$this).'</th>
                				<th>'._l("SMS",$this).'</th>
                			</tr>';
	        $i =  1;
	        		$payment_number = GeneratePaymentNo($i);
                	$html .= '<tr>
                				<td>'.$payment_number.'<input type="hidden" name="inst['.$i.'][payment_number]" class="form-control" value="'.$payment_number.'"></td>
                				<td><input type="text" name="inst['.$i.'][amount]" class="validate[required,custom[number]] form-control valiidate_total" value=""></td>
                				<td><input type="text" name="inst['.$i.'][date]" class="form-control datepicker" value="'.date('d-m-Y').'">
		                				<input type="hidden" name="inst['.$i.'][status]" class="form-control" value="0"></td>
                				<td><input class="btn btn-success" type="button" value="'._l("SMS",$this).'"></td>
                			</tr>';
                	$html .= '</table>
                	</div>';
	        echo $html;
        }
        
        if($_REQUEST['page_type']=='proof'){
        	$html = '';
        	$id= $_REQUEST['id'];
        	$proof_list = $this->NodCMS_general_model->QueryArray('prooflist');
        	$i = $id+1;
        	$html .= '<tr class="remove_'.$i.'">
                		<td>
                			<select name="proof['.$i.'][proof_type]" class="form-control">';
        						foreach ($proof_list as $proof){
			                    	$html .= '<option value="'.$proof['id'].'">'.$proof['title'].'</option>';
			                    }
			            $html .= '</select>';
            $html .= '</td>
                		<td><input type="text" name="proof['.$i.'][proof_number]" placeholder="'._l("Enter Proof Number Here",$this).'" class="form-control" value=""></td>
                		<td><input type="text" name="proof['.$i.'][issue_date]" class="form-control datepicker" value="'.date('d-m-Y').'">
                		<td><input type="text" name="proof['.$i.'][expire_date]" class="form-control datepicker" value="'.date('d-m-Y').'">
		                <td><a onclick="" data-id="'.$i.'" class="btn btn-success add-more-proof" href="javascript:void(0);"><i class="fa fa-plus"></i> </a></td>
                	</tr>';
            echo $html;
        }
    }
    
    
    
    /* LANGUAGE */
	function language($lang)
    {
    	$this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $this->data['data_list']=$this->NodCMS_general_model->get_all_language();
        $this->data['title'] = _l("language",$this);
        $this->data['page_type'] = "language";
        $this->data['content']=$this->load->view($this->mainTemplate.'/language/language',$this->data,true);
        $this->load->view($this->mainTemplate,$this->data);
    }
    function editlanguage($lang,$id='')
    {
    	$this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        if($id!='')
        {
            $this->data['data']=$this->NodCMS_general_model->get_language_detail($id);
            if($this->data['data']==null)
                redirect(base_url().$lang."/language");
        }
        $this->data['title'] = _l("language",$this);
        $this->data['page_type'] = "language";
        $this->data['content']=$this->load->view($this->mainTemplate.'/language/language_edit',$this->data,true);
        $this->load->view($this->mainTemplate,$this->data);
    }
	function defaultlanguage($lang,$id='')
    {
    	$this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        if($id!='')
        {
            $this->data['data']= $data = $this->NodCMS_general_model->get_language_detail($id);
            if($data){
            	$this->NodCMS_general_model->UpdateRow("languages",array("default"=>0));
            	$this->NodCMS_general_model->UpdateRow("languages",array("default"=>1),array("language_id"=>$id));
                redirect(base_url().$lang."/language");
            }else{
            	redirect(base_url().$lang."/language");
            }
        }
    }
    function language_manipulate($lang,$id=null)
    {
    	$this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        if ($_SESSION["user"]["group_id"]==1) {
            if ($this->NodCMS_general_model->language_manipulate($_POST["data"],$id))
            {
                $dir = getcwd().'/nodcms/language/'.$_POST["data"]['language_name'].'/';
                $file = $dir.$_POST["data"]['code'].'_lang.php';
                if(!file_exists($dir)){
                    mkdir($dir);
                }
                if(!file_exists($file)){
                    $myfile = fopen($file, "w") or die("Unable to open file!");
                    $txt = "<?php\n";
                    fwrite($myfile, $txt);
                    fclose($myfile);
                }
                $file = $dir.'backend_lang.php';
                if(!file_exists($file)){
                    $myfile = fopen($file, "w") or die("Unable to open file!");
                    $txt = "<?php\n";
                    fwrite($myfile, $txt);
                    fclose($myfile);
                }
                $this->session->set_flashdata('success', _l('Updated Language',$this));
            }
            else
            {
                $this->session->set_flashdata('error', _l('Updated Language error. Please try later',$this));
            }
        }else{
            $this->session->set_flashdata('error', _l('This request is just fore real admin.',$this));
        }
        redirect(base_url().$lang."/language/");
    }
    function deletelanguage($lang,$id=0)
    {
    	$this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        if ($_SESSION["user"]["group_id"]==1) {
            $this->db->trans_start();
            $this->db->delete('languages', array('language_id' => $id));
            $this->db->trans_complete();
            $this->session->set_flashdata('success', _l('Deleted Language',$this));
        }else{
            $this->session->set_flashdata('error', _l('This request is just fore real admin.',$this));
        }
        redirect(base_url().$lang."/language/");
    }
    function edit_lang_file($lang,$id,$file_name)
    {
    	$this->preset($lang);
    	if (isset($_SESSION["user"]["user_id"])==''){ redirect(base_url()); }
        $this->data['data']=$this->NodCMS_general_model->get_language_detail($id);
        if($this->data['data']==null || !file_exists(getcwd().'/nodcms/language/'.$this->data['data']['language_name'].'/'.$file_name.'_lang.php')){
            $this->session->set_flashdata('error', _l('URL-Request was not exists!',$this));
            redirect(base_url().$lang."/language");
        }
        $this->load->library('Get_lang_in_array');
        $CI = new Get_lang_in_array();
        $this->data['lang_list'] = $CI->load($file_name,$this->data['data']['language_name']);
        if(count($this->data['lang_list'])==0){
            $defaultLangFileName = strlen($file_name)==2?$_SESSION['language']['code']:$file_name;
            $this->data['lang_list'] = $CI->load($defaultLangFileName,$_SESSION['language']['language_name']);
        }
        if(isset($_POST['data'])){
            if ($_SESSION["user"]["group_id"]==1) {
                $post_data = $this->input->post('data');
                $i=0;
                $fileContent = "<?php\n";
                foreach ($this->data['lang_list'] as $key=>&$val) {
                    $fileContent .= '$lang["'.$key.'"] = "'.$post_data[$i].'";'."\n";
                    $val = $post_data[$i];
                    $i++;
                }
                $file = getcwd().'/nodcms/language/'.$this->data['data']['language_name'].'/'.$file_name.'_lang.php';
                if(file_exists($file)){
                    file_put_contents($file, $fileContent);
                }
                $this->session->set_flashdata('success', _l('Edit language file successfully!',$this));
                redirect(base_url().$lang."/edit_lang_file/".$id.'/'.$file_name);
            }else{
            	$this->session->set_flashdata('error', _l('This request is just fore real admin.',$this));
                redirect(base_url().$lang."/language");
            }
        }
        $this->data['file_name'] = $file_name;
        $this->data['languages']=$this->NodCMS_general_model->get_all_language();
        $this->data['title'] = _l("Edit language file",$this);
        $this->data['page_type'] = "edit lang file";       
        $this->data['content']=$this->load->view($this->mainTemplate.'/language/language_edit_file',$this->data,true);
        $this->load->view($this->mainTemplate,$this->data);
    }
    
    
	function Delete($lang,$table,$field,$value)
    {
    	$this->preset($lang);
    	if (!isset($_SESSION["user"]["user_id"])) redirect(base_url());
		
    		$field =  str_replace('-','_',$field);
	    	$table_array = array('members','booking','package','trainees');
	    	if(GetPermission('is_delete')==1){
				if(in_array($table,$table_array)){
					if($table=='members'){
						$member_count = $this->NodCMS_general_model->Count('booking',array('member_id'=>$value));
						if($member_count>0){
							$message = array("status"=>"danger","message"=>"Member details Existing in booking details.");
						}else{
							$payment_count = $this->NodCMS_general_model->Count('payment',array('member_id'=>$value));
							if($payment_count>0){
								$message = array("status"=>"danger","message"=>"Member details Existing in payment details.");
							}else{
								$delete = $this->NodCMS_general_model->DeleteRow($table,array($field=>$value));
								if($delete){
									$message = array("status"=>"success","message"=>"Record deleted successfully.");
								}else{
									$message = array("status"=>"danger","message"=>"Record not deleted.");
								}
							}
						}				
						
						
					}elseif($table=='booking'){
						$member_count = $this->NodCMS_general_model->Count('payment',array('booking_id'=>$value,'payment_status'=>1));
						if($member_count>0){
							$message = array("status"=>"danger","message"=>"Booking details Existing in Payment details.");
						}else{
							$delete_payment = $this->NodCMS_general_model->DeleteRow('payment',array('booking_id'=>$value));
							$delete = $this->NodCMS_general_model->DeleteRow($table,array($field=>$value));
							if($delete){
								$message = array("status"=>"success","message"=>"Record deleted successfully.");
							}else{
								$message = array("status"=>"danger","message"=>"Record not deleted.");
							}
						}
					}elseif($table=='package'){
						$member_count = $this->NodCMS_general_model->Count('booking',array('package_id'=>$value));
						if($member_count>0){
							$message = array("status"=>"danger","message"=>"Package details Existing in Booking details.");
						}else{
							$payment_count = $this->NodCMS_general_model->Count('payment',array('package_id'=>$value));
							if($payment_count>0){
								$message = array("status"=>"danger","message"=>"Package details Existing in payment details.");
							}else{
								$delete_payment = $this->NodCMS_general_model->DeleteRow('package',array('id'=>$value));
								$delete = $this->NodCMS_general_model->DeleteRow($table,array($field=>$value));
								if($delete){
									$message = array("status"=>"success","message"=>"Record deleted successfully.");
								}else{
									$message = array("status"=>"danger","message"=>"Record not deleted.");
								}
							}
						}
					}elseif($table=='trainees'){
						$member_count = $this->NodCMS_general_model->Count('booking',array('trainee_id'=>$value));
						if($member_count>0){
							$message = array("status"=>"danger","message"=>"Trainee details Existing in Booking details.");
						}else{
							$delete = $this->NodCMS_general_model->DeleteRow($table,array($field=>$value));
							if($delete){
								$message = array("status"=>"success","message"=>"Record deleted successfully.");
							}else{
								$message = array("status"=>"danger","message"=>"Record not deleted.");
							}							
						}
					}
				}else{
					$delete = $this->NodCMS_general_model->DeleteRow($table,array($field=>$value));
					if($delete){
						$message = array("status"=>"success","message"=>"Record deleted successfully.");
					}else{
						$message = array("status"=>"danger","message"=>"Record not deleted.");
					}
				}
			}else{
				$message = array("status"=>"danger","message"=>"Permission Denied.");
			}
        
        echo json_encode($message);
    }
    
    function BackUp($lang)
    {
    	$this->preset($lang);
    	//if (!isset($_SESSION["user"]["user_id"])) redirect(base_url());
    	
    	if(isset($_REQUEST['g'])){
    		//echo $this->db->hostname.','.$this->db->username.','.$this->db->password.','.$this->db->database;die();
    		backup_tables($this->db->hostname,$this->db->username,$this->db->password,$this->db->database);
    	}
    	
    	if(isset($_REQUEST['download'])){
    		$this->load->helper('download');
            
            force_download('upload_file/database/'.$_REQUEST['download'], NULL);
    	}
    	
    	$this->data['title'] = _l("Back Up",$this);
        $this->data['page_type'] = "backup";       
        $this->data['content']=$this->load->view($this->mainTemplate.'/page/backup',$this->data,true);
        $this->load->view($this->mainTemplate,$this->data);
    	
    }
    
	function About($lang,$edit = null)
    {
    	$this->preset($lang);
    	if (!isset($_SESSION["user"]["user_id"])) redirect(base_url());
    	$this->data['edit'] = '';
    	$this->data['version_info'] = $this->NodCMS_general_model->QuerySingleRow("about",array('id'=>1));
    	if($edit != null){
    		$this->data['edit'] = $edit;
    		if(isset($_REQUEST['update_version'])){
    			$this->NodCMS_general_model->UpdateRow("about",array('title'=>$_REQUEST['title'],'description'=>$_REQUEST['description']),array('id'=>1));
    			$this->session->set_flashdata('message_success', _l('Updated Successfully',$this));
        		redirect(base_url().$lang."/about/edit",'refresh');
    		}
    		$this->data['version_info'] = $this->NodCMS_general_model->QuerySingleRow("about",array('id'=>1));
    	}
    	$this->data['title'] = _l('About', $this);
        $this->data['page_type'] = "about";
        $this->data['content'] = $this->load->view($this->mainTemplate . '/page/about', $this->data, true);
        $this->load->view($this->mainTemplate, $this->data, '');                
    }
 
}