/*!
 * Start Bootstrap - SB Admin 2 v3.3.7+1 (http://startbootstrap.com/template-overviews/sb-admin-2)
 * Copyright 2013-2016 Start Bootstrap
 * Licensed under MIT (https://github.com/BlackrockDigital/startbootstrap/blob/gh-pages/LICENSE)
 */
$(function() {
    $('#side-menu').metisMenu();
});

//Loads the correct sidebar on window load,
//collapses the sidebar on window resize.
// Sets the min-height of #page-wrapper to window size
$(function() {
    $(window).bind("load resize", function() {
        var topOffset = 50;
        var width = (this.window.innerWidth > 0) ? this.window.innerWidth : this.screen.width;
        if (width < 768) {
            $('div.navbar-collapse').addClass('collapse');
            topOffset = 100; // 2-row-menu
        } else {
            $('div.navbar-collapse').removeClass('collapse');
        }

        var height = ((this.window.innerHeight > 0) ? this.window.innerHeight : this.screen.height) - 1;
        height = height - topOffset;
        if (height < 1) height = 1;
        if (height > topOffset) {
            $("#page-wrapper").css("min-height", (height) + "px");
        }
    });

    var url = window.location;
    // var element = $('ul.nav a').filter(function() {
    //     return this.href == url;
    // }).addClass('active').parent().parent().addClass('in').parent();
    var element = $('ul.nav a').filter(function() {
        return this.href == url;
    }).addClass('active').parent();

    while (true) {
        if (element.is('li')) {
            element = element.parent().addClass('in').parent();
        } else {
            break;
        }
    }
});

$(document).ready(function () {
    $('#add-new-agreement').click(function () {
        var agreement_info = $('#agreement_info').val();
        html = '';
        /*name="agreement['+count+'][agreement_id]"*/
        if (agreement_info) {
            html +='<div class="col-lg-8 col-md-8 col-sm-8 col-xs-8 agreement-content">';
            html +='<select class="select-agreement form-control" id="agreement_list" onchange="change_agreements(this)">';
            html +='<option value="0">SELECT AGREEMENT</option>';
            $.each($.parseJSON(agreement_info), function (idx, obj) {
                html += '<option value="'+obj.id+'">'+obj.title+'</option>';
            });
            html +='</select>';
            html +='<div class="agreement-form"></div>';
            html +='</div>';
        }
        $("#agreement-div").append(html);
    });
});

function change_agreements(obj) {
    var option_val = $(obj).val();
    /*var count = $('.agreement_data_'+option_val).length;*/
    var count = $('.agreement-form-data').length;
    count = count+1;
    html ='';
    html +='<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 reset-padding agreement-form-data agreement_data_'+option_val+'">';
    html +='<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">';
    html +='<label>FROM</label>';
    html +='<input type="hidden" name="agreement['+count+'][agreement_id]" value="'+option_val+'">';
    html +='<input type="text" onkeypress="return isNumberKey(this,event)" name="agreement['+count+'][price]" class="commission_input" placeholder="€" size="10" value="">';
    html +='<label>Euro</label>';
    html +='</div>';
    html +='<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">';
    html +='<input type="text" onkeypress="return isNumberKey(this,event)" name="agreement['+count+'][commission]" class="commission_input" size="10" value="">';
    html +='<label>% Commission</label>';
    html +='</div>';
    html +='<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4 text-right">';
    html +='<a href="javascript:void(0)" class="text-color" option-val="'+option_val+'" onclick="add_agreements(this)">+ ADD MORE</a>';
    html +='<a href="javascript:void(0)" class="text-color remove-agreement" style="display: none" onclick="remove_agreements(this)">- REMOVE</a>';
    html +='</div>';
    html +='</div>';
    html +='<div class="add-more-form"></div>';

    $(obj).closest('.agreement-content').find(".agreement-form").html(html);
}

function add_agreements(obj) {
    $(obj).css('display','none');
    $(obj).closest('.agreement-form-data').find('.remove-agreement').css('display','block');
    var option_val = $(obj).attr('option-val');
    /*var count = $('.agreement_data_'+option_val).length;*/
    var count = $('.agreement-form-data').length;
    count = count+1;
    html ='';
    html +='<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 reset-padding agreement-form-data agreement_data_'+option_val+'">';
    html +='<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">';
    html +='<label>FROM</label>';
    html +='<input type="hidden" name="agreement['+count+'][agreement_id]" value="'+option_val+'">';
    html +='<input type="text" onkeypress="return isNumberKey(this,event)" name="agreement['+count+'][price]" class="commission_input" placeholder="€" size="10" value="">';
    html +='<label>Euro</label>';
    html +='</div>';
    html +='<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">';
    html +='<input type="text" onkeypress="return isNumberKey(this,event)" name="agreement['+count+'][commission]" class="commission_input" size="10" value="">';
    html +='<label>% Commission</label>';
    html +='</div>';
    html +='<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4 text-right">';
    html +='<a href="javascript:void(0)" class="text-color" option-val="'+option_val+'" onclick="add_agreements(this)">+ ADD MORE</a>';
    html +='<a href="javascript:void(0)" class="text-color remove-agreement" style="display: none" onclick="remove_agreements(this)">- REMOVE</a>';
    html +='</div>';
    html +='</div>';

    $(obj).closest('.agreement-content').find(".add-more-form").append(html);
}

function remove_agreements(obj) {
    $(obj).closest('.agreement-form-data').hide('slow');
    $(obj).closest('.agreement-form-data').empty('slow');
}

$(document).ready(function(){
    $('#mobile-menu').click(function() {
        $(this).toggleClass("active");
        $("#mySidenav").toggleClass('show-div-width');
        $("#main").toggleClass('show-div-margin');
    });
    $('.access-denied').click(function() {
        $('.top-right').notify({
            message: {text: "Access Denied"},
            type: "danger"
        }).show();
    });


    $('[data-toggle="popover"]').popover();

    $('.notify').on('click', function(event) {
        var notify_id = $(this).attr('notify-id');
        $('#admin-notify_'+notify_id).toggle('show');
    });

});



function isNumberKey(txt,evt)
{
    $return = true;
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    /*alert(charCode);*/
    if (charCode != 46 && charCode > 31
        && (charCode < 48 || charCode > 57))
        $return = false;
    if (charCode == 44) {
        if (txt.value.indexOf(',') === -1) {
            return true;
        } else {
            $return = false;
        }
    }
    return $return;
}

function getFormattedDate(date) {
    var year = date.getFullYear();
    var month = (1 + date.getMonth()).toString();
    month = month.length > 1 ? month : '0' + month;
    var day = date.getDate().toString();
    day = day.length > 1 ? day : '0' + day;
    return  day+ '.' + month + '.' + year;
}

