<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes with
| underscores in the controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = "Nodcms_general";
$route['404_override'] = '';

$route['([a-z][a-z])'] = 'Nodcms_general/index/$1';
$route['([a-z][a-z])/page/([0-9]+)'] = 'Nodcms_general/page/$1/$2';
$route['([a-z][a-z])/extension/([0-9]+)'] = 'Nodcms_general/extensionDetail/$1/$2';
$route['([a-z][a-z])/register'] = 'Nodcms_general/register/$1';
$route['([a-z][a-z])/login'] = 'Nodcms_general/login/$1';
$route['([a-z][a-z])/forget-password'] = 'Nodcms_general/forgetPassword/$1';
$route['([a-z][a-z])/login/([a-zA-Z0-9-]+)'] = 'Nodcms_general/login/$1/$2';
$route['([a-z][a-z])/active_account/([a-zA-Z0-9-]+)/([a-zA-Z0-9-]+)'] = 'Nodcms_general/resetPassword/$1/$2/$3';
$route['([a-z][a-z])/reset-password/([a-zA-Z0-9-]+)/([a-zA-Z0-9-]+)'] = 'Nodcms_general/resetPassword/$1/$2/$3';
$route['([a-z][a-z])/profile-password'] = 'Nodcms_general/profilePassword/$1';
$route['([a-z][a-z])/new-feeds'] = 'Nodcms_general/rss/$1';
$route['([a-z][a-z])/sitemap.xml'] = 'Nodcms_general/siteMapXML/$1';

//NEW ROUTS
$route['([a-z][a-z])/dashboard'] = 'Nodcms_general/dashboard/$1';

$route['([a-z][a-z])/members'] = 'Nodcms_general/Members/$1';
$route['([a-z][a-z])/member'] = 'Nodcms_general/Member/$1';
$route['([a-z][a-z])/print-member'] = 'Nodcms_general/PrintMember/$1';

$route['([a-z][a-z])/trainees'] = 'Nodcms_general/Trainees/$1';
$route['([a-z][a-z])/trainee'] = 'Nodcms_general/Trainee/$1';
$route['([a-z][a-z])/inquiry'] = 'Nodcms_general/Inquiry/$1';
$route['([a-z][a-z])/inquiries'] = 'Nodcms_general/Inquiries/$1';

$route['([a-z][a-z])/calendar'] = 'Nodcms_general/Calendar/$1';

$route['([a-z][a-z])/booking-list'] = 'Nodcms_general/BookingList/$1';
$route['([a-z][a-z])/booking'] = 'Nodcms_general/Booking/$1';
$route['([a-z][a-z])/print-booking'] = 'Nodcms_general/PrintBooking/$1';

$route['([a-z][a-z])/payments'] = 'Nodcms_general/Payments/$1';
$route['([a-z][a-z])/payment'] = 'Nodcms_general/Payment/$1';
$route['([a-z][a-z])/direct-payment'] = 'Nodcms_general/DirectPayment/$1';

$route['([a-z][a-z])/notification'] = 'Nodcms_general/Notification/$1';
$route['([a-z][a-z])/cpanel'] = 'Nodcms_general/Cpanel/$1';
$route['([a-z][a-z])/company'] = 'Nodcms_general/CompanyProfile/$1';
$route['([a-z][a-z])/package'] = 'Nodcms_general/Package/$1';
$route['([a-z][a-z])/packages'] = 'Nodcms_general/Packages/$1';

$route['([a-z][a-z])/expense'] = 'Nodcms_general/Expense/$1';
$route['([a-z][a-z])/expenses'] = 'Nodcms_general/Expenses/$1';

$route['([a-z][a-z])/employees'] = 'Nodcms_general/Employees/$1';
$route['([a-z][a-z])/employee'] = 'Nodcms_general/Employee/$1';

$route['([a-z][a-z])/users'] = 'Nodcms_general/Users/$1';
$route['([a-z][a-z])/user'] = 'Nodcms_general/User/$1';

$route['([a-z][a-z])/groups'] = 'Nodcms_general/Groups/$1';
$route['([a-z][a-z])/group'] = 'Nodcms_general/Group/$1';

$route['([a-z][a-z])/proofs'] = 'Nodcms_general/Proofs/$1';
$route['([a-z][a-z])/proof'] = 'Nodcms_general/Proof/$1';

$route['([a-z][a-z])/about'] = 'Nodcms_general/About/$1';
$route['([a-z][a-z])/about/([a-zA-Z0-9-]+)'] = 'Nodcms_general/About/$1/$2';

$route['([a-z][a-z])/access-denied'] = 'Nodcms_general/AccessDenied/$1';

$route['([a-z][a-z])/ajax'] = 'Nodcms_general/Ajax/$1';

$route['([a-z][a-z])/print-payment'] = 'Nodcms_general/PrintPayment/$1';

$route['([a-z][a-z])/reports'] = 'Nodcms_general/Reports/$1';

$route['([a-z][a-z])/backup'] = 'Nodcms_general/BackUp/$1';

$route['([a-z][a-z])/print-report'] = 'Nodcms_general/PrintReport/$1';

$route['([a-z][a-z])/print-expire-package'] = 'Nodcms_general/PrintExpirePackage/$1';

$route['([a-z][a-z])/payment-report'] = 'Nodcms_general/PaymentReport/$1';
$route['([a-z][a-z])/package-report'] = 'Nodcms_general/PackageReport/$1';
$route['([a-z][a-z])/report-package'] = 'Nodcms_general/ReportPackage/$1';
$route['([a-z][a-z])/package-print'] = 'Nodcms_general/PackagePrint/$1';
/* LANGUAGE */

$route['([a-z][a-z])/language'] = 'Nodcms_general/language/$1';
$route['([a-z][a-z])/editlanguage/([0-9]+)'] = 'Nodcms_general/editlanguage/$1/$2';
$route['([a-z][a-z])/defaultlanguage/([0-9]+)'] = 'Nodcms_general/defaultlanguage/$1/$2';
$route['([a-z][a-z])/addlanguage'] = 'Nodcms_general/editlanguage/$1';
$route['([a-z][a-z])/deletelanguage/([0-9]+)'] = 'Nodcms_general/deletelanguage/$1/$2';
$route['([a-z][a-z])/language_manipulate'] = 'Nodcms_general/language_manipulate/$1';
$route['([a-z][a-z])/language_manipulate/([0-9]+)'] = 'Nodcms_general/language_manipulate/$1/$2';
$route['([a-z][a-z])/edit_lang_file/([0-9]+)/([a-zA-Z0-9-]+)'] = 'Nodcms_general/edit_lang_file/$1/$2/$3';

$route['([a-z][a-z])/state-list'] = 'Nodcms_general/StateList/$1';
$route['([a-z][a-z])/delete/([a-zA-Z0-9-]+)/([a-zA-Z0-9-]+)/([0-9]+)'] = 'Nodcms_general/Delete/$1/$2/$3/$4';


//$route['([a-z][a-z])/(.*)']= $route['default_controller']."/$2/$1";
$route['admin-sign']= "Nodcms_admin_sign/index";
$route['admin-sign/login']= "Nodcms_admin_sign/login";
$route['admin-sign/logout']= "Nodcms_admin_sign/logout";
$route['admin']= "Nodcms_general_admin/index";
$route['admin/(.*)']= "Nodcms_general_admin/$1";
$route['translate_uri_dashes'] = FALSE;
