<?php
/**
 * Created by PhpStorm.
 * User: Mojtaba
 * Date: 9/15/2015
 * Time: 8:00 PM
 * Project: NodCMS
 * Website: http://www.nodcms.com
 */
if ( ! function_exists('_l')){
    function _l($label, $obj)
    {
        $return = $obj->lang->line($label);
        if ($return){
            return $return;
        }else{
            if($obj->router->fetch_class()=="Nodcms_general"){
                if(!in_array($label,$obj->langArray)){
                    $file = getcwd()."/nodcms/language/".$_SESSION["language"]["language_name"].'/'.$_SESSION["language"]["code"]."_lang.php";
                    if(file_exists($file)){
                        $current = file_get_contents($file);
                        $current .= "\n";
                        $current .= '$lang["'.$label.'"] = "'.$label.'";';
                        file_put_contents($file, $current);
                        $obj->langArray[$label] = $label;
                    }
                }
            }elseif($obj->router->fetch_class()=="Nodcms_general_admin"){
                if(!in_array($label,$obj->langArray)){
                    $file = getcwd()."/nodcms/language/".$_SESSION["language"]["language_name"]."/backend_lang.php";
                    if(file_exists($file)){
                        $current = file_get_contents($file);
                        $current .= "\n";
                        $current .= '$lang["'.$label.'"] = "'.$label.'";';
                        file_put_contents($file, $current);
                        $obj->langArray[$label] = $label;
                    }
                }
            }
            return $label;
        }
    }
}
if ( ! function_exists('substr_string')){
    function substr_string($text,$start = 0,$count = 10,$end_text=" ..."){
        $explode = explode(" ",strip_tags($text));
        return implode(" ",array_splice($explode,$start,$count)).(count($explode)>$count?$end_text:"");
    }
}
if ( ! function_exists('my_int_date')){
    function my_int_date($date)
    {
        return date("d.m.Y",$date);
    }
}
if ( ! function_exists('my_int_fullDate')){
    function my_int_fullDate($time){
        return date("j F Y | g:i A",$time);
    }
}
if ( ! function_exists('my_int_justDate')){
    function my_int_justDate($time){
        return date("j F Y",$time);
    }
}
if ( ! function_exists('my_int_justTime')){
    function my_int_justTime($time){
        return date("g:i A",$time);
    }
}

				
if ( ! function_exists('CurrentTime')){
    function CurrentTime(){
    	$tz = 'Asia/Dubai'; // your required location time zone.
		//$timestamp = time();
		//$dt = new DateTime("now", new DateTimeZone($tz)); //first argument "must" be a string
		//$dt->setTimestamp($timestamp); //adjust the object to correct timestamp
		date_default_timezone_set($tz);
        return date('H:i:s');
    }
}
				
if ( ! function_exists('date_to_DB')){
    function date_to_DB($date){
    	if($date!=''){
        	return date("Y-m-d",$date);
    	}else{
    		return "0000-00-00";
    	}
    }
}

if ( ! function_exists('date_to_Display')){
    function date_to_Display($date){
    	if($date!='0000-00-00'){
        	return date("d-m-Y",$date);
    	}else{
    		return "-";
    	}
    }
}

if ( ! function_exists('DisplayDateTime')){
    function DisplayDateTime($date){
    	if($date!='0000-00-00'){
			$time = date("h:i:s",strtotime($date));
			if($time!= "12:00:00"){
				return date("d-m-Y g:i A",strtotime($date));
			}else{
				return date("d-m-Y ",strtotime($date))."11:30 AM";
			}
    	}else{
    		return "-";
    	}
    }
}

if ( ! function_exists('Notification_status')){
    function Notification_status($satus){
        if($satus==0){
        	$message = '<span class="label label-primary">Success</span>';
        }else{
        	$message = '<span class="label label-danger">Failed</span>';
        }
        return $message;
    }
}

if ( ! function_exists('ExpenseType')){
    function ExpenseType($satus){
        if($satus==0){
        	$message = '<span class="label label-info">Indirect</span>';
        }elseif($satus==1){
        	$message = '<span class="label label-success">Direct</span>';
        }
        return $message;
    }
}


if ( ! function_exists('Status')){
    function Status($satus){
        if($satus==0){
        	$message = '<span class="label label-danger">Inactive</span>';
        }elseif($satus==1){
        	$message = '<span class="label label-success">Active</span>';
        }
        return $message;
    }
}

if ( ! function_exists('PaymentStatus')){
    function PaymentStatus($satus){
        if($satus==0){
        	$message = '<span class="label label-danger">Pending</span>';
        }elseif($satus==1){
        	$message = '<span class="label label-success">Paid</span>';
        }
        return $message;
    }
}

if ( ! function_exists('frontendStatisticCalc')){
    function frontendStatisticCalc($obj,$language){
        //        Statistic
        $visitorMinDate = $obj->NodCMS_general_model->getMinDateVisitor();
        if($visitorMinDate!=0){
            $visitorMaxDate = $obj->NodCMS_general_model->getMaxDateVisitor();
            $times = $visitorMaxDate - $visitorMinDate;
            if($times >= 86400){
                $days = round($times / 86400);
                $visitorMinDate = (mktime(0,0,0,date("m",$visitorMinDate),(date("j",$visitorMinDate)),date("Y",$visitorMinDate)));
                for($d=0;$d<$days;$d++){
                    $maxTime = (mktime(0,0,0,date("m",$visitorMinDate),(date("j",$visitorMinDate)),date("Y",$visitorMinDate))) + 86400;
                    $obj->NodCMS_general_model->updateStatistic(strtotime(date("d.m.Y",$visitorMinDate)),$maxTime);
                    $visitorMinDate = $maxTime;
                }
            }
        }
        $visitor = $obj->NodCMS_general_model->getDuplicateVisitor(session_id(),$_SERVER["REQUEST_URI"]);
        if(count($visitor) == 0){
            // Get IP address
            if ( isset($_SERVER['HTTP_CLIENT_IP']) && ! empty($_SERVER['HTTP_CLIENT_IP'])) {
                $ip = $_SERVER['HTTP_CLIENT_IP'];
            } elseif ( isset($_SERVER['HTTP_X_FORWARDED_FOR']) && ! empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else {
                $ip = (isset($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : '0.0.0.0';
            }

            $ip = filter_var($ip, FILTER_VALIDATE_IP);
            $ip = ($ip === false) ? '0.0.0.0' : $ip;
            $obj->load->library('spyc');
            $visitor_data = array(
                "session_id"=>session_id(),
                "user_id"=>isset($_SESSION["user"]["user_id"])?$_SESSION["user"]["user_id"]:0,
                "created_date"=>time(),
                "updated_date"=>time(),
                "user_agent"=>Spyc::YAMLDump($_SERVER["HTTP_USER_AGENT"]),
                "user_ip"=>$ip,
                "language_id"=>$language["language_id"],
                "language_code"=>$language["code"],
                "referrer"=>isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:"",
                "request_url"=>$_SERVER['REQUEST_URI'],
                "count_view"=>1
            );
            $obj->NodCMS_general_model->insertVisitors($visitor_data);
        }else{
            $visitor = @reset($visitor);
            $visitor_data = array(
                "user_id"=>isset($_SESSION["user"]["user_id"])?$_SESSION["user"]["user_id"]:0,
                "updated_date"=>time(),
                "count_view"=>$visitor["count_view"]+1
            );
            $obj->NodCMS_general_model->updateDuplicateVisitor(session_id(),$_SERVER["REQUEST_URI"],$visitor_data);
        }
    }
}


/*CUSTOM FUNCTIONS*/


if ( ! function_exists('Pagination')) {
    function Pagination($pages, $url,$page_url,$current,$last)
    {
echo '<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <nav aria-label="Page navigation">
            <ul class="pagination">';
                if($pages)
                {
                    $url['page'] = "1";
                    $urlString = http_build_query($url);
                    echo '<li><a href="'.base_url().$page_url.$urlString.'"><span aria-hidden="true">&laquo;</span></a></li>';
                    foreach($pages as $pag)
                    {
                        if($pag==$current)
                        {
                            $url['page'] = $pag;
                            $urlString = http_build_query($url);
                            echo '<li><a style="color:#7a7a7a;" href="'.base_url().$page_url.$urlString.'">'.$pag.'</a></li>';
                        }else
                        {
                            $url['page'] = $pag;
                            $urlString = http_build_query($url);
                            echo '<li><a href="'.base_url().$page_url.$urlString.'">'.$pag.'</a></li>';
                        }
                    }
                    $url['page'] = $last;
                    $urlString = http_build_query($url);
                    echo '<li><a href="'.base_url().$page_url.$urlString.'"><span aria-hidden="true">&raquo;</span></a></li>';
                }
            echo '</ul>
            </nav>
        </div>';
    }
}

if ( ! function_exists('GetCountries')){
    function GetCountries(){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        return $obj->NodCMS_general_model->QueryArray("countries",array(''),'name','ASC');
    }
}

if ( ! function_exists('GetCountryInfo')){
    function GetCountryInfo($id){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $data = $obj->NodCMS_general_model->QuerySingleRow("countries",array('id'=>$id));
        return ($data) ? $data->name : '';
    }
}
if ( ! function_exists('GetStateInfo')){
    function GetStateInfo($id){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $data = $obj->NodCMS_general_model->QuerySingleRow("states",array('id'=>$id));
        return $data->name;
    }
}

if ( ! function_exists('GetPaymentInfo')){
    function GetPaymentInfo($id){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $data = $obj->NodCMS_general_model->QuerySingleRow("payment_type",array('id'=>$id));
        return $data->title;
    }
}

if ( ! function_exists('GetStateList')){
    function GetStateList($id){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $data = $obj->NodCMS_general_model->QueryArray("states",array('country_id'=>$id));
        return $data;
    }
}

if ( ! function_exists('GetSingleInfo')){
    function GetSingleInfo($table,$field,$value){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        return $obj->NodCMS_general_model->QuerySingleRow($table,array($field=>$value));        
    }
}

if ( ! function_exists('GetLanguage')){
    function GetLanguage(){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        return $obj->NodCMS_general_model->QueryArray("languages");        
    }
}

if ( ! function_exists('GetPermission')){
    function GetPermission($field){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $group_date = $obj->NodCMS_general_model->QuerySingleRow('groups',array('group_id'=>$_SESSION["user"]["group_id"]));
        return $group_date->$field;        
    }
}

if ( ! function_exists('GetPaidAmountTotal')){
    function GetPaidAmountTotal($booking_id){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $payment_list = $obj->NodCMS_general_model->QueryArray('payment',array('booking_id'=>$booking_id));
        $total_payment = array();
        $payment_status = 0;
        if($payment_list){
        	foreach ($payment_list as $payment){
        		$total_payment[] = $payment['payment_amount'];
        	}
        	if(count($total_payment)){
        		$total_payment_amount= array_sum($total_payment);        		
        		$booking_amount = $obj->NodCMS_general_model->QuerySingleRow('booking',array('id'=>$booking_id));
        		if($booking_amount->amount==$total_payment_amount){
        			$payment_status = 1;
        		}else{
        			$payment_status = 0;
        		}
        	}else{
        		$payment_status = 0;
        	}
        }else{
        	$payment_status = 0;
        }
        return $payment_status;
    }
}

if ( ! function_exists('GenerateMemberNo')){
    function GenerateMemberNo(){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $cpanel_settings = $obj->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        $member_data = $obj->NodCMS_general_model->QuerySingleRowLast('members',array(''),"id","DESC");
        if($member_data){
        	//$split_number = explode("-", $member_data->member_number);
        	$numbers = preg_replace('/[^0-9]/', '', $member_data->member_number);
			$letters = preg_replace('/[^a-zA-Z]/', '', $member_data->member_number);
        	$total = ($numbers+1);
        	return $cpanel_settings->member_prefix.(sprintf("%04d", $total));
        }else{
        	
        	return $cpanel_settings->member_prefix.'0001';
        }
    }
}

if ( ! function_exists('GenerateBookingNo')){
    function GenerateBookingNo(){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $cpanel_settings = $obj->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        $member_data = $obj->NodCMS_general_model->QuerySingleRowLast('booking',array(''),"id","DESC");
        if($member_data){
        	//$split_number = explode("-", $member_data->member_number);
        	$numbers = preg_replace('/[^0-9]/', '', $member_data->booking_number);
			$letters = preg_replace('/[^a-zA-Z]/', '', $member_data->booking_number);
        	$total = ($numbers+1);
        	return $cpanel_settings->booking_prefix.(sprintf("%04d", $total));
        }else{        	
        	return $cpanel_settings->booking_prefix.'0001';
        }
    }
}

if ( ! function_exists('GenerateEmployeeNo')){
    function GenerateEmployeeNo(){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $cpanel_settings = $obj->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        $member_data = $obj->NodCMS_general_model->QuerySingleRowLast('employees',array(''),"id","DESC");
        if($member_data){
        	//$split_number = explode("-", $member_data->member_number);
        	$numbers = preg_replace('/[^0-9]/', '', $member_data->employee_number);
			$letters = preg_replace('/[^a-zA-Z]/', '', $member_data->employee_number);
        	$total = ($numbers+1);
        	return $cpanel_settings->employee_prefix.(sprintf("%04d", $total));
        }else{        	
        	return $cpanel_settings->employee_prefix.'0001';
        }
    }
}

if ( ! function_exists('GeneratePaymentNo')){
    function GeneratePaymentNo($number = 1){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $cpanel_settings = $obj->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        $member_data = $obj->NodCMS_general_model->QuerySingleRowLast('payment',array(''),"id","DESC",$cpanel_settings->payment_prefix);
        if($member_data){
        	//$split_number = explode("-", $member_data->payment_number);
        	$numbers = preg_replace('/[^0-9]/', '', $member_data->payment_number);
			$letters = preg_replace('/[^a-zA-Z]/', '', $member_data->payment_number);
        	$total = ($numbers+$number);
        	return $cpanel_settings->payment_prefix.(sprintf("%04d", $total));
        }else{
        	return $cpanel_settings->payment_prefix.(sprintf("%04d", $number));
        }
    }
}

if ( ! function_exists('GenerateBookingPaymentNo')){
    function GenerateBookingPaymentNo($number = 1){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $cpanel_settings = $obj->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        $member_data = $obj->NodCMS_general_model->QuerySingleRowLast('payment',array(''),"id","DESC",$cpanel_settings->booking_payment_prefix);
        if($member_data){
        	//$split_number = explode("-", $member_data->payment_number);
        	$numbers = preg_replace('/[^0-9]/', '', $member_data->payment_number);
			$letters = preg_replace('/[^a-zA-Z]/', '', $member_data->payment_number);
        	$total = ($numbers+$number);
        	return $cpanel_settings->booking_payment_prefix.(sprintf("%04d", $total));
        }else{
        	return $cpanel_settings->booking_payment_prefix.(sprintf("%04d", $number));
        }
    }
}

if ( ! function_exists('PriceFormat')){
    function PriceFormat($price){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        $cpanel_settings = $obj->NodCMS_general_model->QuerySingleRow('cpanel',array('id'=>1));
        if($price){
	        return number_format($price,$cpanel_settings->decimal_place,".",",");
        }else{
        	return '';
        }
    }
}

if ( ! function_exists('NumberToDate')){
    function NumberToDate($convert){
        $obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        
        $display_format = '';
        
        $years = ($convert / 365) ; // days / 365 days
		$years = floor($years); // Remove all decimals
		if ($years>0){
			$display_format .= $years.' years ';
		}

		$month = ($convert % 365) / 30.5; // I choose 30.5 for Month (30,31) ;)
		$month = floor($month); // Remove all decimals
		if ($month>0){
			$display_format .= $month.' month ';
		}

		$days = ($convert % 365) % 30.5; // the rest of days
		$display_format .= $days.' days';
		return $display_format;
    }
}


if ( ! function_exists('P')){
    function P($data,$die = 1){
    	echo '<pre>'.print_r($data).'</pre>';
        if($die==1){
	        die();
        }
    }
}

if( ! function_exists('SendSMS')){
	function SendSMS($number,$message_id){
		$obj =& get_instance();
        $obj->load->model('NodCMS_general_model');
        
        $message_text = $obj->NodCMS_general_model->QuerySingleRow("smstemplates",array('id'=>$message_id));
        
		if($number){
        		$param = array(
		        'username' 	=> 'qbmsoft',	
		        'password' 	=> 'qbm987',
		        'senderid' 	=> 'SMS Alert',
		        'text' 		=> $message_text->message,
		        'type' 		=> 'text',
		        'datetime' 	=> date("Y-m-d G:i:s"),
		    );
		    $post = 'to=' . $number;
		    foreach ($param as $key => $val) {
		        $post .= '&' . $key . '=' . rawurlencode($val);
		    }
		    $url = "https://www.smartsmsgateway.com/api/api_json.php";
		    $ch = curl_init();
		    curl_setopt($ch, CURLOPT_URL, $url);
		    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
		    curl_setopt($ch, CURLOPT_HTTPHEADER, array("Connection: close"));
		    $result = curl_exec($ch);
		    $status = 0;
		    if(curl_errno($ch)) {
		        $result = "cURL ERROR: " . curl_errno($ch) . " " . curl_error($ch);
		        $status = 1;
		    } else {
		        $returnCode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
		        switch($returnCode) {
		            case 200 :
		                break;
		            default :
		                $result = "HTTP ERROR: " . $returnCode;
		                $status = 1;
		        }
		    }
		    curl_close($ch);
		    //print $result;
		    $args = array(
		    	'mobile_number' => $number,
			    'message'   	=> $message_text->message,
			    'result'   		=> $result,
			    'created_date' 	=> strtotime(date("Y-m-d")),
		    	'status'		=> $status
		    	);
		    $insert = $obj->NodCMS_general_model->InsertRow("notifications",$args);
        	}
	}
}

if( ! function_exists('backup_tables')){
	function backup_tables($host,$user,$pass,$name,$tables = '*')
	{
	    $return = '';
	    $link = mysqli_connect($host,$user,$pass,$name);
	   // mysqli_select_db($link,$name);
		//$db_select = mysqli_select_db($link, $name);
		
	    //get all of the tables
	    if($tables == '*')
	    {
	        $tables = array();
	        $result = mysqli_query($link,'SHOW TABLES');
	        while($row = mysqli_fetch_row($result))
	        {
	            $tables[] = $row[0];
	        }
	    }
	    else
	    {
	        $tables = is_array($tables) ? $tables : explode(',',$tables);
	    }
	
	    //cycle through
	    foreach($tables as $table)
	    {
	        $result = mysqli_query($link,'SELECT * FROM '.$table);
	        $num_fields = mysqli_num_fields($result);
	
	        $return.= 'DROP TABLE '.$table.';';
	        $row2 = mysqli_fetch_row(mysqli_query($link,'SHOW CREATE TABLE '.$table));
	        $return.= "\n\n".$row2[1].";\n\n";
	
	        for ($i = 0; $i < $num_fields; $i++)
	        {
	            while($row = mysqli_fetch_row($result))
	            {
	                $return.= 'INSERT INTO '.$table.' VALUES(';
	                for($j=0; $j < $num_fields; $j++)
	                {
	                    $row[$j] = addslashes($row[$j]);
	                    $row[$j] = preg_replace("/\n/","\\n",$row[$j]);
	                    if (isset($row[$j])) { $return.= '"'.$row[$j].'"' ; } else { $return.= '""'; }
	                    if ($j < ($num_fields-1)) { $return.= ','; }
	                }
	                $return.= ");\n";
	            }
	        }
	        $return.="\n\n\n";
	    }
	
	$directory = "upload_file/database/";
	$filecount = 1;
	$files = glob($directory . "*");
	if ($files){
	 $filecount = count($files);
	 $filecount++;
	}
	    //save file
	    $handle = fopen('upload_file/database/db-backup-'.date("d-m-Y").'_('.$filecount.').sql','w+');
	    fwrite($handle,$return);
	    fclose($handle);
	}
}