<style>
@media screen {
    #printSection {
        display: block;
    }
}
@media print {
    table {
        page-break-after: auto;
        page-break-inside: auto;
        width:100%;
        border-width: 1px solid #000;
        font-size:16px;
        font-family:Arial;
    }

     td{
        padding:2px 5px 2px 5px;
    }

}
</style>
<div class="wrapper">
  <!-- Main content -->
  <div class="row" id="printSection">
  		<div class="col-sm-12" style="border-bottom: 1px solid #e6e6e6;">
  			<div class="col-sm-8">
  				<h1><?php echo $company_detail->company_name;?></h1>
  			</div>
  			<div class="col-sm-4">
  			<?php $tz = 'Asia/Dubai'; // your required location time zone.
$timestamp = time();
$dt = new DateTime("now", new DateTimeZone($tz)); //first argument "must" be a string
$dt->setTimestamp($timestamp); //adjust the object to correct timestamp
 ?>
  				<h5>Date & Time : <?php echo $dt->format('d-m-Y g:i a'); ?></h5>
  			</div>	
  		</div>
    	<div class="col-md-12 page-list table-responsive">
            <table class="table" id="printTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo _l("P No",$this);?></th>
                        <th><?php echo _l("M Name",$this);?></th>
                        <th><?php echo _l("P Name",$this);?></th>
                        <th><?php echo _l("P Type",$this);?></th>
                        <th><?php echo _l("C Name",$this);?></th>
                        <th><?php echo _l("P Date",$this);?></th>
                        <th><?php echo _l("Amount",$this);?></th>
                        <?php 
                        if($cpanel_setting->vat==1){
                        	echo '<th>'._l("VAT %",$this).'</th>';
                        	echo '<th>'._l("VAT Total",$this).'</th>';
                        	echo '<th>'._l("Total Amount",$this).'</th>';
                        }
                        ?>
                    </tr>
                </thead>
                <tbody>
	                <?php 
	                if($payment_data){
	                	$sno = 1;
	                	$total_non_vat_amount = array();
	                	$total_vat_amount = array();
	                	$total_vat = array();
	                	$amount_total = array();
	                	foreach ($payment_data as $payment){
	                		if($payment['package_info']){
	                			$package_name = $payment['package_info']->package_name;
	                		}else{
	                			$package_info = GetSingleInfo("package","id", $payment['payment_info']['package_id']);
	                			if($package_info){
	                				$package_name = $package_info->package_name;
	                			}else{
	                				$package_name = '';
	                			}
	                		}
	                		$user_info = GetSingleInfo("users","user_id", $payment['payment_info']['user_id']);
	                		if($cpanel_setting->vat==1){
	                			$display_amount = PriceFormat($payment['payment_info']['actual_amount']);
	                			$amount_total[] = $payment['payment_info']['actual_amount'];
	                		}else{
	                			$display_amount = PriceFormat($payment['payment_info']['payment_amount']);
	                			$amount_total[] = $payment['payment_info']['payment_amount'];
	                		}
	                		echo '<tr class="remove_'.$payment['payment_info']['id'].'">
			                        <td>'.$sno.'</td>
			                        <td>'.$payment['payment_info']['payment_number'].'</td>
			                        <td>'.$payment['member_info']->member_name.'</td>
			                        <td>'.$package_name.'</td>
			                        <td>'.$payment['payment_type']->title.'</td>
			                        <td>'.$user_info->username.'</td>
			                        <td>'.date("d-m-Y h:s A",(strtotime($payment['payment_info']['payment_date']))).'</td>
			                        <td class="text-right">'.$display_amount.'</td>';
	                				
	                		$total_non_vat_amount[] = $display_amount;
	                		if($cpanel_setting->vat==1){
		                		$amount = $payment['payment_info']['actual_amount'];
						        $actual_amount = '';
						        $vat_amount = '';
						        $vat_enable = 'no';
						        $vat_percentage = '';
						        if($cpanel_setting->vat==1){
						        	if($cpanel_setting->include_vat==1){
						        		$per_amount_in = ($amount*(100/(100+$cpanel_setting->vat_amount)));
						        		$actual_amount = $per_amount_in;
						        		$per_amount = ($per_amount_in*($cpanel_setting->vat_amount/100));
						        		$vat_amount = $per_amount;
						        		$amount = $per_amount+$per_amount_in;
						        		if($payment['payment_info']['actual_amount']){
							        		echo '<td class="text-right">'.$cpanel_setting->vat_amount.'</td>';
							        		echo '<td class="text-right">'.PriceFormat($vat_amount).'</td>';
							        		echo '<td class="text-right">'.PriceFormat($amount).'</td>';
						        		}else{
						        			echo '<td></td>';
							        		echo '<td></td>';
							        		echo '<td class="text-right">'.PriceFormat($payment['payment_info']['payment_amount']).'</td>';
						        		}
						        	}else{
						        		$actual_amount = $amount;
						        		$per_amount = ($amount*($cpanel_setting->vat_amount/100));
						        		$vat_amount = $per_amount;
						        		$amount = $per_amount+$amount;
						        		if($payment['payment_info']['actual_amount']){
							        		echo '<td class="text-right">'.$cpanel_setting->vat_amount.'</td>';
							        		echo '<td class="text-right">'.PriceFormat($vat_amount).'</td>';
							        		echo '<td class="text-right">'.PriceFormat($amount).'</td>';
						        		}else{
						        			echo '<td></td>';
							        		echo '<td></td>';
							        		echo '<td class="text-right">'.PriceFormat($payment['payment_info']['payment_amount']).'</td>';
						        		}
						        	}
						        	if($payment['payment_info']['actual_amount']){
							        	$total_vat[] = $vat_amount;
							        	$total_vat_amount[] = $amount;
						        	}else{
						        		$total_vat_amount[] = $payment['payment_info']['payment_amount'];
						        	}
						        	$vat_enable = 'yes';
						        	$vat_percentage = $cpanel_setting->vat_amount;
						        }
	                		}
	                		
			                    echo '</tr>';	
	                		$sno++;
	                	}
	                	if($cpanel_setting->vat==1){
	                		echo '<tr>
		                			<td colspan="7" class="text-right">'._l("TOTAL : ",$this).'</td>
		                			<td class="text-right">'.PriceFormat(array_sum($amount_total)).'</td>
		                			<td class="text-right"></td>
		                			<td class="text-right">'.PriceFormat(array_sum($total_vat)).'</td>
		                			<td class="text-right">'.PriceFormat(array_sum($total_vat_amount)).'</td>
	                		</tr>';
	                	}else{
	                		echo '<tr>
		                			<td colspan="7" class="text-right">'._l("TOTAL : ",$this).'</td>
		                			<td class="text-right">'.PriceFormat(array_sum($total_non_vat_amount)).'</td>
	                		</tr>';
	                	}
	                }
	                ?>                    
                </tbody>
            </table>
        </div>
    </div>
  <!-- /.content -->
</div>
<script>
$(document).ready(function () { 
	window.print(); 
	});
</script>